<?php
namespace Tanzsport\Kader;

use Tanzsport\Kader\Model\Kaderliste;

class KaderlistenExcelReaderTest extends \PHPUnit_Framework_TestCase
{

	private $expected;

	public function setUp()
	{
		parent::setUp();
		$this->expected = $this->loadExpected();
	}

	public function testReader()
	{
		$files = array('Bundeskaderlisten.xls', 'Bundeskaderlisten.xlsx');
		$namen = array('Kombination' => 3, 'Latein' => 28, 'Standard' => 21, 'Formationen' => 6, 'DRBV' => 4, 'Professional Division' => 2);

		foreach ($files as $file) {
			$reader = $this->createReader($file);
			$listen = $reader->getKaderlisten();
			$this->assertNotNUll($listen);
			$this->assertEquals(6, count($listen));

			foreach ($namen as $name => $anzahl) {
				$liste = $reader->findKaderliste($name);
				$this->assertNotNull($liste, "Liste geladen: {$file}");
				$this->assertEquals($anzahl, count($liste->getEintraege()), "Anzahl stimmt: {$file} => {$name} = {$anzahl}");
				$this->assertExpected($name, $liste);
				$this->assertTrue(count($liste->getKopfzeile()) == 5);
			}

		}
	}

	/**
	 * @expectedException \InvalidArgumentException
	 * @expectedExcetpionMessage gültige Excel-Datei
	 */
	public function testInvalidFile()
	{
		$reader = $this->createReader('invalid.jpg');
		$reader->getKaderlisten();
	}

	private function createReader($file)
	{
		return new KaderlistenExcelReader(__DIR__ . '/' . $file);
	}

	private function loadExpected()
	{
		$json = file_get_contents(__DIR__ . '/expected.json');
		return json_decode($json);
	}

	private function assertExpected($name, Kaderliste $liste)
	{
		if (isset($this->expected->$name)) {
			foreach ($this->expected->$name as $ex) {
				$eintraege = $liste->getEintraege();
				if (isset($eintraege[$ex->index])) {
					$eintrag = $eintraege[$ex->index];
					$vars = (array)$ex->values;
					foreach ($vars as $var => $expectedValue) {
						$this->assertEquals($expectedValue, $eintrag->$var, "Wert stimmt nicht überein: {$name}, {$ex->index} => {$var} = {$expectedValue}");
					}
				} else {
					$this->fail("Eintrag nicht vorhaden: {$name}, index={$ex->index}");
				}
			}
		}
	}
}