<?php
namespace Tanzsport\Kader\Model;

class Kaderliste
{

	/**
	 * @var string
	 */
	private $name;

	/**
	 * @var string[]
	 */
	private $kopzeile = array();

	/**
	 * @var KaderlisteEintrag[]
	 */
	private $eintraege = array();

	public function __construct(\PHPExcel_Worksheet $sheet)
	{
		if ($sheet == null) {
			throw new \InvalidArgumentException("Worksheet erforderlich!");
		}
		$this->name = $sheet->getTitle();
		if ($this->sheetContainsCells($sheet)) {
			$first = true;
			foreach ($sheet->getRowIterator() as $row) {
				if ($first) {
					$this->readHeaderCells($row);
				} else {
					$eintrag = new KaderlisteEintrag($row);
					if (!$eintrag->isEmpty()) {
						$this->eintraege[] = $eintrag;
					}
				}
				$first = false;
			}
		}
	}

	/**
	 * @return KaderlisteEintrag[]
	 */
	public function getEintraege()
	{
		return $this->eintraege;
	}

	/**
	 * @return \string[]
	 */
	public function getKopfzeile()
	{
		return $this->kopfzeile;
	}

	/**
	 * @return string
	 */
	public function getName()
	{
		return $this->name;
	}

	/**
	 * @return bool
	 */
	public function isEmpty()
	{
		return count($this->eintraege) == 0;
	}

	private function sheetContainsCells(\PHPExcel_Worksheet $sheet)
	{
		$cell = $sheet->getCellByColumnAndRow(0, 2);
		return $cell->getValue() != null;
	}

	private function readHeaderCells(\PHPExcel_Worksheet_Row $row)
	{
		$iter = $row->getCellIterator();
		$iter->setIterateOnlyExistingCells(true);
		foreach ($iter as $cell) {
			$this->readHeaderCell($cell);
		}
	}

	private function readHeaderCell(\PHPExcel_Cell $cell)
	{
		if($cell->getValue() != null) {
			$this->kopfzeile[] = $cell->getValue();
		}
	}
}
