<?php
namespace Tanzsport\Kader;

use Tanzsport\Kader\Model\Kaderliste;

class KaderlistenExcelReader
{

	/**
	 * @var string
	 */
	private $path;

	/**
	 * @var Kaderliste[]
	 */
	private $kaderlisten;

	public function __construct($path)
	{
		if ($path == null) {
			throw new \InvalidArgumentException("Datei erforderlich!");
		}
		if (!@file_exists($path)) {
			throw new \InvalidArgumentException("Datei existiert nicht!");
		}
		if (!@is_readable($path)) {
			throw new \InvalidArgumentException("Datei ist nicht lesbar!");
		}

		$this->path = realpath($path);
	}

	/**
	 * @param $name Name der Kaderliste
	 * @return null|Kaderliste
	 * @throws \InvalidArgumentException
	 */
	public function findKaderliste($name)
	{
		if ($name == null) {
			throw new \InvalidArgumentException("Name erforderlich!");
		}
		foreach ($this->kaderlisten as $kaderliste) {
			if ($kaderliste->getName() == $name) {
				return $kaderliste;
			}
		}
		return null;
	}

	/**
	 * @return Model\Kaderliste[]
	 */
	public function getKaderlisten()
	{
		if ($this->kaderlisten == null) {
			$this->kaderlisten = array();
			$this->read();
		}
		return $this->kaderlisten;
	}

	private function read()
	{
		$excel = null;
		try {
			$excel = \PHPExcel_IOFactory::load($this->path);
		} catch (\Exception $e) {

		}
		if ($excel == null) {
			throw new \InvalidArgumentException("Datei ist keine gültige Excel-Datei!");
		}
		foreach ($excel->getWorksheetIterator() as $sheet) {
			if ($sheet->getSheetState() == \PHPExcel_Worksheet::SHEETSTATE_VISIBLE) {
				$kaderliste = new Kaderliste($sheet);
				if (!$kaderliste->isEmpty()) {
					$this->kaderlisten[] = $kaderliste;
				}
			}
		}
	}

}