<?php
namespace Tanzsport\Kader\Model;

class KaderlisteEintrag
{

	/**
	 * @var bool
	 */
	private $empty = false;

	/**
	 * @var string
	 */
	private $turnierart;
	/**
	 * @var string
	 */
	private $kader;
	/**
	 * @var string
	 */
	private $name;
	/**
	 * @var string
	 */
	private $verein;
	/**
	 * @var string
	 */
	private $ltv;

	public function __construct(\PHPExcel_Worksheet_Row $row)
	{
		if ($row == null) {
			throw new \InvalidArgumentException("Tabellenzeile erforderlich!");
		}
		$iter = $row->getCellIterator();
		$iter->setIterateOnlyExistingCells(true);
		$first = true;
		foreach ($iter as $cell) {
			if ($first) {
				if ($cell->getValue() == null) {
					$this->empty = true;
					break;
				}
			}
			$this->parseCell($cell);
			$first = false;
		}
	}

	public function __get($val)
	{
		if (isset($this->$val)) {
			return $this->$val;
		}
	}

	/**
	 * @return bool
	 */
	public function isEmpty()
	{
		return $this->empty;
	}

	private function parseCell(\PHPExcel_Cell $cell)
	{
		switch ($cell->getColumn()) {
			case "A":
				$this->turnierart = trim($cell->getValue());
				return;
			case "B":
				$this->kader = trim($cell->getValue());
				return;
			case "C":
				$this->name = trim($cell->getValue());
				return;
			case "D":
				$this->verein = trim($cell->getValue());
				return;
			case "E":
				$this->ltv = trim($cell->getValue());
				return;
			default:
				return;
		}
	}
}