<?php
namespace Tanzsport\Kader;

use Tanzsport\Kader\Model\Kaderliste;

class KaderlistenExcelReader
{

	/**
	 * @var string
	 */
	private $path;

	/**
	 * @var Kaderliste[]
	 */
	private $kaderlisten;

	public function __construct($path)
	{
		if ($path == null) {
			throw new \InvalidArgumentException("Datei erforderlich!");
		}
		if (!@file_exists($path)) {
			throw new \InvalidArgumentException("Datei existiert nicht!");
		}
		if (!@is_readable($path)) {
			throw new \InvalidArgumentException("Datei ist nicht lesbar!");
		}

		$this->path = realpath($path);
	}

	/**
	 * @param $name Name der Kaderliste
	 * @return null|Kaderliste
	 * @throws \InvalidArgumentException
	 */
	public function findKaderliste($name)
	{
		if ($name == null) {
			throw new \InvalidArgumentException("Name erforderlich!");
		}
		foreach ($this->kaderlisten as $kaderliste) {
			if ($kaderliste->getName() == $name) {
				return $kaderliste;
			}
		}
		return null;
	}

	/**
	 * @return Model\Kaderliste[]
	 */
	public function getKaderlisten(array $worksheetNumbers = null)
	{
		if ($this->kaderlisten == null) {
			$this->kaderlisten = array();
			$this->read($worksheetNumbers);
		}
		return $this->kaderlisten;
	}

	private function read(array $worksheetNumbers = null)
	{
		$excel = null;
		try {
			$excel = \PHPExcel_IOFactory::load($this->path);
		} catch (\Exception $e) {

		}
		if ($excel == null) {
			throw new \InvalidArgumentException("Datei ist keine gültige Excel-Datei!");
		}

		$seen = 1;

		foreach ($excel->getWorksheetIterator() as $sheet) {
			if ($sheet->getSheetState() == \PHPExcel_Worksheet::SHEETSTATE_VISIBLE) {
				if ($worksheetNumbers == null || empty($worksheetNumbers) || in_array($seen, $worksheetNumbers)) {
					$kaderliste = new Kaderliste($sheet);
					if (!$kaderliste->isEmpty()) {
						$this->kaderlisten[] = $kaderliste;
					}
				}
				$seen++;
			}
		}
	}

}