<?php

declare(strict_types=1);

namespace Tanzsport\ExcelTeamListReader\Model;

use PhpOffice\PhpSpreadsheet\Cell\Cell;
use PhpOffice\PhpSpreadsheet\Worksheet\Row;

class TeamListEntry
{
    private bool $empty = false;
    private ?string $turnierart = null;
    private ?string $kader = null;
    private ?string $name = null;
    private ?string $verein = null;
    private ?string $ltv = null;

    public function __construct(Row $row)
    {
        $iter = $row->getCellIterator();
        $iter->setIterateOnlyExistingCells(true);
        $first = true;
        foreach ($iter as $cell) {
            if ($first) {
                if ($cell->getValue() == null) {
                    $this->empty = true;
                    break;
                }
            }
            $this->parseCell($cell);
            $first = false;
        }
    }

    public function __get($val)
    {
        if (isset($this->$val)) {
            return $this->$val;
        }
    }

    public function isEmpty(): bool
    {
        return $this->empty;
    }

    private function parseCell(Cell $cell): void
    {
        switch ($cell->getColumn()) {
            case "A":
                $this->turnierart = $this->trim($cell->getValue());
                return;
            case "B":
                $this->kader = $this->trim($cell->getValue());
                return;
            case "C":
                $this->name = $this->trim($cell->getValue());
                return;
            case "D":
                $this->verein = $this->trim($cell->getValue());
                return;
            case "E":
                $this->ltv = $this->trim($cell->getValue());
                return;
            default:
        }
    }

    private function trim($value): string
    {
        return $value ? trim($value) : '';
    }
}
