<?php

declare(strict_types=1);

namespace Tanzsport\ExcelTeamListReader\Model;

use PhpOffice\PhpSpreadsheet\Cell\Cell;
use PhpOffice\PhpSpreadsheet\Worksheet\Row;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class TeamList
{
    private string $name;

    /**
     * @var string[]
     */
    private array $kopfzeile = [];

    /**
     * @var TeamListEintrag[]
     */
    private array $eintraege = [];

    public function __construct(Worksheet $sheet)
    {
        $this->name = $sheet->getTitle();
        if ($this->sheetContainsCells($sheet)) {
            $first = true;
            foreach ($sheet->getRowIterator() as $row) {
                if ($first) {
                    $this->readHeaderCells($row);
                } else {
                    $eintrag = new TeamListEntry($row);
                    if (!$eintrag->isEmpty()) {
                        $this->eintraege[] = $eintrag;
                    }
                }
                $first = false;
            }
        }
    }

    /**
     * @return TeamListEintrag[]
     */
    public function getEintraege(): array
    {
        return $this->eintraege;
    }

    /**
     * @return string[]
     */
    public function getKopfzeile(): array
    {
        return $this->kopfzeile;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return bool
     */
    public function isEmpty(): bool
    {
        return count($this->eintraege) == 0;
    }

    private function sheetContainsCells(Worksheet $sheet): bool
    {
        $cell = $sheet->getCellByColumnAndRow(1, 2);
        return $cell->getValue() != null;
    }

    private function readHeaderCells(Row $row): void
    {
        $iter = $row->getCellIterator();
        $iter->setIterateOnlyExistingCells(true);
        foreach ($iter as $cell) {
            $this->readHeaderCell($cell);
        }
    }

    private function readHeaderCell(Cell $cell): void
    {
        if ($cell->getValue() != null) {
            $this->kopfzeile[] = $cell->getValue();
        }
    }
}
