<?php
namespace Tanzsport\Rangliste;

use Tanzsport\Rangliste\Model\Rangliste;

class RanglistenReaderTest extends \PHPUnit_Framework_TestCase
{

	/**
	 * @var RanglistenReader
	 */
	private $reader;

	public function setUp()
	{
		parent::setUp();
		$this->reader = new RanglistenReader(__DIR__ . '/files');
	}

	public function testArrayConstructor()
	{
		$reader = new RanglistenReader(array(__DIR__ . '/files/g55_100808.csv', __DIR__ . '/files/juglat_100731.csv'));
		$this->assertEquals(2, count($reader->getNeuesteRanglisten()));
	}

	public function testGetDaten()
	{
		$daten = $this->reader->getDaten('g55');
		$this->assertEquals(2, count($daten));
	}

	public function testGetNeuesRanglisten()
	{
		$ranglisten = $this->reader->getNeuesteRanglisten();
		$this->assertEquals(10, count($ranglisten));
	}

	public function testGetNeuesteRangliste()
	{
		$rangliste = $this->reader->getNeuesteRangliste('g55');
		$this->assertNotNull($rangliste);
		$this->assertEquals('20140420', $rangliste->getDatum()->format('Ymd'));
	}

	/**
	 * @expectedException \InvalidArgumentException
	 * @expectedExceptionMessage Keine Ranglisten für Typ
	 */
	public function testGetNeuesteRanglisteDoesntExist()
	{
		$this->reader->getNeuesteRangliste('xyz');
	}

	public function testGetRangliste()
	{
		$datum = \DateTime::createFromFormat('Ymd', '20140531');
		$rangliste = $this->reader->getRangliste('seniistd', $datum);
		$this->assertNotNull($rangliste);
	}

	public function testGetRanglisteNotFound()
	{
		$datum = \DateTime::createFromFormat('Ymd', '20140530');
		$rangliste = $this->reader->getRangliste('seniistd', $datum);
		$this->assertNull($rangliste);
	}
}