<?php
namespace Tanzsport\Rangliste\Model;

class RanglisteTest extends \PHPUnit_Framework_TestCase
{

	private $config;

	public function setUp()
	{
		parent::setUp();
		$this->config = (array)json_decode(file_get_contents(__DIR__ . '/../../../../main/Tanzsport/Rangliste/ranglisten.json'));
	}

	public function testCsv()
	{
		$fileInfo = new \SplFileInfo(__DIR__ . '/../files/g55_100808.csv');
		$rangliste = new Rangliste('g55', $this->config['g55'], '20100808', $fileInfo);
		$rangliste->read();
		$this->assertEquals(92, count($rangliste->getEintraege()));
		$eintrag = $rangliste->getEintraege()[63];
		$this->assertEquals(64, $eintrag->getPlatz());
		$this->assertEquals("Andersch, Günter", $eintrag->getPartner());
		$this->assertEquals("Andersch-Gerber, Mechthild", $eintrag->getPartnerin());
		$this->assertEquals("Blau-Silber Berlin Tanzsportclub e.V.", $eintrag->getVerein());
		$this->assertEquals(47, $eintrag->getPunkte());
	}

	public function testExcel()
	{
		$fileInfo = new \SplFileInfo(__DIR__ . '/../files/g55_140420.xls');
		$rangliste = new Rangliste('g55', $this->config['g55'], '20140420', $fileInfo);
		$rangliste->read();
		$this->assertEquals(77, count($rangliste->getEintraege()));
		$eintrag = $rangliste->getEintraege()[67];
		$this->assertEquals(68, $eintrag->getPlatz());
		$this->assertEquals("Kanning, Carsten", $eintrag->getPartner());
		$this->assertEquals("Kanning, Heidemarie", $eintrag->getPartnerin());
		$this->assertEquals("Grün-Gold-Club Bremen e.V.", $eintrag->getVerein());
		$this->assertEquals(24, $eintrag->getPunkte());
	}

	public function testExcelEmptyPlatz()
	{
		$fileInfo = new \SplFileInfo(__DIR__ . '/../files/juniistd_140531.xls');
		$rangliste = new Rangliste('juniistd', $this->config['juniistd'], '20140531', $fileInfo);
		$rangliste->read();
		$this->assertEquals(46, count($rangliste->getEintraege()));
		$eintrag = $rangliste->getEintraege()[21];
		$this->assertNull($eintrag->getPlatz());
		$this->assertEquals("Kudla, Jeffry", $eintrag->getPartner());
		$this->assertEquals("Ising, Eleonore", $eintrag->getPartnerin());
		$this->assertEquals("1. TSC Frankfurt/Oder e.V.", $eintrag->getVerein());
		$this->assertEquals(105, $eintrag->getPunkte());
	}

}