<?php
namespace Tanzsport\Rangliste\Model;

class RanglisteEintrag
{

	/**
	 * @var int
	 */
	private $platz;

	/**
	 * @var string
	 */
	private $partner;

	/**
	 * @var string
	 */
	private $partnerin;

	/**
	 * @var string
	 */
	private $verein;

	/**
	 * @var
	 */
	private $punkte;

	public function __construct($platz, $partner, $partnerin, $verein, $punkte)
	{
		$this->platz = $platz;
		$this->partner = $partner;
		$this->partnerin = $partnerin;
		$this->verein = $verein;
		$this->punkte = $punkte;
	}

	public function getPlatz()
	{
		return $this->platz;
	}

	public function getPartner()
	{
		return $this->partner;
	}

	public function getPartnerin()
	{
		return $this->partnerin;
	}

	public function getVerein()
	{
		return $this->verein;
	}

	public function getPunkte()
	{
		return $this->punkte;
	}

	public function __toString()
	{
		return sprintf('%1$s=%2$s - %3$s (%4$s) [%5$s]', $this->platz == null ? '()' : $this->platz, $this->partner, $this->partnerin, $this->verein, $this->punkte);
	}
}