<?php

namespace Tanzsport\ExcelRankingReader;

use PHPUnit\Framework\TestCase;

class ExcelRankingReaderTest extends TestCase
{

    /**
     * @var ExcelRankingReader
     */
    private $reader;

    public function setUp(): void
    {
        parent::setUp();
        $this->reader = new ExcelRankingReader(__DIR__ . '/files');
    }

    public function testArrayConstructor()
    {
        $reader = new ExcelRankingReader(array(__DIR__ . '/files/g55_100808.csv', __DIR__ . '/files/juglat_100731.csv'));
        $this->assertEquals(2, count($reader->getNeuesteRanglisten()));
    }

    public function testGetDaten()
    {
        $daten = $this->reader->getDaten('g55');
        $this->assertEquals(2, count($daten));
    }

    public function testGetNeuesRanglisten()
    {
        $ranglisten = $this->reader->getNeuesteRanglisten();
        $this->assertEquals(10, count($ranglisten));
    }

    public function testGetNeuesteRangliste()
    {
        $rangliste = $this->reader->getNeuesteRangliste('g55');
        $this->assertNotNull($rangliste);
        $this->assertEquals('20140420', $rangliste->getDatum()->format('Ymd'));
    }

    public function testGetNeuesteRanglisteDoesntExist()
    {
        $this->expectExceptionMessage('Keine Ranglisten für Typ');
        $this->reader->getNeuesteRangliste('xyz');
    }

    public function testGetRangliste()
    {
        $datum = \DateTime::createFromFormat('Ymd', '20140531');
        $rangliste = $this->reader->getRangliste('seniistd', $datum);
        $this->assertNotNull($rangliste);
    }

    public function testGetRanglisteNotFound()
    {
        $datum = \DateTime::createFromFormat('Ymd', '20140530');
        $rangliste = $this->reader->getRangliste('seniistd', $datum);
        $this->assertNull($rangliste);
    }
}
