<?php
declare(strict_types=1);

namespace Tanzsport\ExcelRankingReader\Model;

class RankingEntry
{

    /**
     * @var string|int|null
     */
    private $platz;
    /**
     * @var string|null
     */
    private $partner;
    /**
     * @var string|null
     */
    private $partnerin;
    /**
     * @var string|null
     */
    private $verein;
    /**
     * @var string|int|null
     */
    private $punkte;

    public function __construct($platz, $partner, $partnerin, $verein, $punkte)
    {
        $this->platz = $platz;
        $this->partner = $partner;
        $this->partnerin = $partnerin;
        $this->verein = $verein;
        $this->punkte = $punkte;
    }

    /**
     * @return int|string|null
     */
    public function getPlatz()
    {
        return $this->platz;
    }

    /**
     * @return string|null
     */
    public function getPartner()
    {
        return $this->partner;
    }

    /**
     * @return string|null
     */
    public function getPartnerin()
    {
        return $this->partnerin;
    }

    /**
     * @return string|null
     */
    public function getVerein()
    {
        return $this->verein;
    }

    /**
     * @return int|string|null
     */
    public function getPunkte()
    {
        return $this->punkte;
    }

    public function __toString()
    {
        return sprintf('%1$s=%2$s - %3$s (%4$s) [%5$s]', $this->platz == null ? '()' : $this->platz, $this->partner, $this->partnerin, $this->verein, $this->punkte);
    }
}
