<?php
declare(strict_types=1);

namespace Tanzsport\ExcelEventListReader\Model;

use DateTime;

/**
 * Veranstaltung in der Event-Liste
 *
 * @package Tanzsport\ExcelEventListReader\Model
 *
 * @property-read DateTime $datum
 * @property-read DateTime $datumVon
 * @property-read DateTime | null $datumBis
 * @property-read string $titel
 * @property-read string $ausrichter
 * @property-read array $links
 */
class Event
{
    private DateTime $datumVon;

    private string $titel;

    private string $ausrichter;

    private array $links;

    public function __construct(DateTime $datumVon, string $titel, ?string $ausrichter, ?DateTime $datumBis = null)
    {
        $this->datumVon = $datumVon;
        $this->titel = $titel;
        $this->ausrichter = $ausrichter;
        $this->datumBis = $datumBis;
        $this->links = array();
    }

    public function __get($key)
    {
        switch ($key) {
            case 'datum':
            case 'datumVon':
                return $this->datumVon;
            case 'datumBis':
                return $this->datumBis;
            case 'titel':
                return $this->titel;
            case 'ausrichter':
                return $this->ausrichter;
            case 'links':
                return $this->links;
        }
    }

    public function __isset($key)
    {
        switch ($key) {
            case 'datum':
            case 'datumVon':
                return isset($this->datumVon);
            case 'datumBis':
                return isset($this->datumBis);
            case 'titel':
                return isset($this->titel);
            case 'ausrichter':
                return isset($this->ausrichter);
            case 'links':
                return isset($this->links);
        }
    }

    public function addLink(?string $text, ?string $url): void
    {
        if ($url) {
            $this->links[] = new Link($url, $text);
        }
    }
}
