<?php
declare(strict_types=1);

use PHPUnit\Framework\TestCase;
use Tanzsport\ExcelEventListReader\Model\Link;

class LinkTest extends TestCase
{

    /**
     * @test
     */
    public function usesInfoAsTextWhenEmpty()
    {
        $link = new Link('http://tanzsport.de', null);
        $this->assertTrue(isset($link->url));
        $this->assertEquals('http://tanzsport.de', $link->url);
        $this->assertTrue(isset($link->text));
        $this->assertEquals('Info', $link->text);
    }

    /**
     * @test
     */
    public function prependsDefaultUrlScheme()
    {
        $link = new Link('tanzsport.de', null);
        $this->assertTrue(isset($link->url));
        $this->assertEquals('http://tanzsport.de', $link->url);
    }
}
