<?php
declare(strict_types=1);

namespace Tanzsport\Events\Model;

use PHPUnit\Framework\TestCase;
use Tanzsport\ExcelEventListReader\Model\EventList;

class EventListTest extends TestCase
{

    /**
     * @test
     */
    public function initializesWithEmptyAndNow()
    {
        $list = new EventList();
        $this->assertCount(0, $list);
        $now = new \DateTime();
        $this->assertTrue($list->getStand()->format('U') - $now->format('U') < 10);
    }

    /**
     * @test
     */
    public function timestampIsCopiedWhenClonedForCurrent()
    {
        $list = new EventList([], new \DateTime('2020-01-01'));
        $cloned = $list->onlyCurrent();
        $this->assertEquals($list->getStand(), $cloned->getStand());
    }
}
