<?php
declare(strict_types=1);

namespace Tanzsport\ExcelEventListReader\Model;

/**
 * Link in einer Veranstaltung
 *
 * @package Tanzsport\ExcelEventListReader\Model
 *
 * @property-read string $text
 * @property-read string $url
 */
class Link
{
    private string $text;

    private string $url;

    public function __construct(string $url, ?string $text)
    {
        $this->text = $text ? $text : "Info";
        if (parse_url($url, PHP_URL_SCHEME) === null) {
            $this->url = "http://" . $url;
        } else {
            $this->url = $url;
        }
    }

    public function __get($key)
    {
        switch ($key) {
            case 'text':
                return $this->text;
            case 'url':
                return $this->url;
            default:
                return null;
        }
    }

    public function __isset($key)
    {
        switch ($key) {
            case 'text':
                return isset($this->text);
            case 'url':
                return isset($this->url);
            default:
                return false;
        }
    }
}
