<?php
namespace Tanzsport\Events;

class EventlisteExcelReaderTest extends \PHPUnit_Framework_TestCase
{

	private function createReader($file)
	{
		return new EventlisteExcelReader($file);
	}


	public function testBla()
	{
		$reader = $this->createReader(__DIR__ . '/Eventliste.xlsx');
		$events = $reader->readEventsInWorksheet(1);

		$this->assertNotNull($events);
		$this->assertNotNull($events->getStand());
		$this->assertEquals(4, count($events));

		$event = $events[0];
		$this->assertEquals(\DateTime::createFromFormat('d.m.y H:i:s', '01.06.13 00:00:00'), $event->datum);
		$this->assertEquals('Rosenblattpokal', $event->titel);
		$this->assertCount(1, $event->links);

		$event = $events[1];
		$this->assertEquals(\DateTime::createFromFormat('d.m.y H:i:s', '01.06.13 00:00:00'), $event->datum);
		$this->assertEquals('Biber-Trophy', $event->titel);
		$this->assertCount(1, $event->links);

		$event = $events[2];
		$this->assertEquals(\DateTime::createFromFormat('d.m.Y H:i:s', '20.12.2099 00:00:00'), $event->datum);
		$this->assertEquals('Weihnachtspokal', $event->titel);
		$this->assertCount(1, $event->links);

		$event = $events[3];
		$this->assertEquals(\DateTime::createFromFormat('d.m.Y H:i:s', '06.12.2099 00:00:00'), $event->datum);
		$this->assertEquals('Nikolauspokal', $event->titel);
		$this->assertCount(2, $event->links);

		$events->sort();
		$this->assertCount(4, $events);
		$this->assertEquals('Nikolauspokal', $events[2]->titel);

		$this->assertCount(2, $events->onlyCurrent());

		$iterated = 0;
		foreach($events as $e) {
			$iterated++;
		}
		$this->assertEquals(4, $iterated);
	}
}