<?php
namespace Tanzsport\Events\Model;

/**
 * Link in einer Veranstaltung
 *
 * @package Tanzsport\Events\Model
 *
 * @property-read $text
 * @property-read $url
 */
class Link
{

	/**
	 * @var string
	 */
	private $text;

	/**
	 * @var string
	 */
	private $url;

	public function __construct($text, $url)
	{
		$this->text = $text ? $text : "Info";
		if (parse_url($url, PHP_URL_SCHEME) === null) {
			$this->url = "http://" . $url;
		} else {
			$this->url = $url;
		}
	}

	public function __get($key)
	{
		switch ($key) {
			case 'text':
				return $this->text;
			case 'url':
				return $this->url;
		}
	}

	public function __isset($key)
	{
		switch ($key) {
			case 'text':
				return isset($this->text);
			case 'url':
				return isset($this->url);
		}
	}
}