<?php
namespace Tanzsport\Events\Model;

/**
 * Event-Liste
 *
 * @package Tanzsport\Events\Model
 */
class EventListe implements \ArrayAccess, \Countable, \Iterator
{

	private $events;
	private $stand;
	private $key = 0;

	public function __construct(array $events = null, \DateTime $stand = null)
	{
		if (!$events) {
			$this->events = array();
		} else {
			$this->events = $events;
		}
		if ($stand == null) {
			$this->stand = new \DateTime('now');
		} else {
			$this->stand = $stand;
		}
	}

	public function offsetExists($offset)
	{
		return isset($this->events[$offset]);
	}

	public function offsetGet($offset)
	{
		return $this->events[$offset];
	}

	public function offsetSet($offset, $value)
	{
		if ($offset) {
			$this->events[$offset] = $value;
		} else {
			$this->events[] = $value;
		}
	}

	public function offsetUnset($offset)
	{
		if ($offset) {
			unset($this->events[$offset]);
		}
	}

	public function count()
	{
		return count($this->events);
	}

	public function current()
	{
		return $this->events[$this->key];
	}

	public function next()
	{
		$this->key++;
	}

	public function key()
	{
		return $this->key;
	}

	public function valid()
	{
		return isset($this->events[$this->key]);
	}

	public function rewind()
	{
		$this->key = 0;
	}

	/**
	 * @return $this
	 */
	public function sort()
	{
		usort($this->events, array($this, 'compareEvents'));
		return $this;
	}

	/**
	 * @return array|EventListe
	 */
	public function onlyCurrent()
	{
		$current = new EventListe();
		$now = new \DateTime('now');
		$u = $now->format('U');
		foreach ($this->events as $e) {
			if ($e->datum->format('U') >= $u) {
				$current[] = $e;
			}
		}
		return $current;
	}

	public function compareEvents(Event $a, Event $b)
	{
		$u1 = $a->datum->format('U');
		$u2 = $b->datum->format('U');
		if ($u1 == $u2) {
			return strcmp($a->titel, $b->titel);
		} else {
			return $u1 < $u2 ? -1 : 1;
		}
	}

	/**
	 * @return \DateTime
	 */
	public function getStand()
	{
		return $this->stand;
	}
}