<?php
namespace Tanzsport\Events\Model;

/**
 * Veranstaltung in der Event-Liste
 *
 * @package Tanzsport\Events\Model
 *
 * @property-read \DateTime $datum
 * @property-read \DateTime $datumVon
 * @property-read \DateTime $datumBis
 * @property-read string $titel
 * @property-read string $ausrichter
 * @property-read array $links
 */
class Event
{

	/**
	 * @var \DateTime
	 */
	private $datumVon;

	/**
	 * @var string
	 */
	private $titel;

	/**
	 * @var string
	 */
	private $ausrichter;

	/**
	 * @var array
	 */
	private $links;

	public function __construct(\DateTime $datumVon, $titel, $ausrichter, \DateTime $datumBis = null)
	{
		$this->datumVon = $datumVon;
		$this->titel = $titel;
		$this->ausrichter = $ausrichter;
		$this->datumBis = $datumBis;
		$this->links = array();
	}

	public function __get($key)
	{
		switch ($key) {
			case 'datum':
			case 'datumVon':
				return $this->datumVon;
			case 'datumBis':
				return $this->datumBis;
			case 'titel':
				return $this->titel;
			case 'ausrichter':
				return $this->ausrichter;
			case 'links':
				return $this->links;
		}
	}

	public function __isset($key)
	{
		switch ($key) {
			case 'datum':
			case 'datumVon':
				return isset($this->datumVon);
			case 'datumBis':
				return isset($this->datumBis);
			case 'titel':
				return isset($this->titel);
			case 'ausrichter':
				return isset($this->ausrichter);
			case 'links':
				return isset($this->links);
		}
	}

	public function addLink($text, $url)
	{
		if ($url) {
			$this->links[] = new Link($text, $url);
		}
	}
}