<?php
declare(strict_types=1);

namespace Tanzsport\ContaoTeamlistBundle\Model;

class TeamPortraits
{

    /**
     * @var string[]
     */
    private $links = [];

    public function add(string $name, string $url): void
    {
        $this->links[] = ['name' => $name, 'url' => $url];
    }

    public function exists($name): bool
    {
        if ($name) {
            foreach ($this->links as $link) {
                if (str_contains($link['name'], $name)) {
                    return true;
                }
            }
        }

        return false;
    }

    public function getUrl($name): ?string
    {
        if ($name) {
            foreach ($this->links as $link) {
                if (str_contains($link['name'], $name)) {
                    return $link['url'];
                }
            }
        }

        return null;
    }
}
