<?php
declare(strict_types=1);

namespace Tanzsport\ContaoTeamlistBundle\Controller\FrontendModule;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FilesModel;
use Contao\ModuleModel;
use Contao\PageModel;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Tanzsport\ContaoTeamlistBundle\Model\TeamPortraits;
use Tanzsport\ExcelTeamListReader\ExcelTeamListReader;

/**
 * @FrontendModule("td_kaderlisten",
 *     template="mod_kaderlisten",
 *     category="td",
 *     renderer="forward"
 * )
 */
class TeamlistFrontendModuleController extends AbstractFrontendModuleController
{
    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $template->kaderlisten = [];

        if ($model->singleSRC) {
            $file = FilesModel::findByPk($model->singleSRC);
            if ($file) {
                $reader = new ExcelTeamListReader($file->path);
                $template->kaderlisten = $reader->getTeamLists();
                $template->portraits = $this->findPortraits();
            }
        }
        return $template->getResponse()->setPrivate();
    }

    protected function findPortraits(): TeamPortraits
    {
        $portraits = new TeamPortraits();
        if ($page = $this->getPageModel()) {
            $subPages = PageModel::findPublishedByPid($page->id);
            if ($subPages != null) {
                while ($subPages->next()) {
                    if ($subPages->published) {
                        $portraits->add($subPages->title, $subPages->getFrontendUrl());
                    }
                }
            }
        }
        return $portraits;
    }
}
