<?php

namespace Tanzsport\ContaoTanzspiegelBundle;

class ModuleTanzspiegelNavigation extends ModuleTanzspiegel
{

    protected $strTemplate = 'mod_tanzspiegel_navigation';

    public function generate()
    {
        if (TL_MODE == 'BE') {
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### ' . $GLOBALS['TL_LANG']['FMD']['td_tanzspiegel_navigation'][0] . ' ###';
            $objTemplate->title = $this->headline;
            $objTemplate->id = $this->id;
            $objTemplate->link = $this->name;
            $objTemplate->href = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        if (!isset($_GET['items']) && $GLOBALS['TL_CONFIG']['useAutoItem'] && isset($_GET['auto_item'])) {
            \Input::setGet('items', \Input::get('auto_item'));
        }

        $this->loadLanguageFile('td_ts_fe');
        return parent::generate();
    }

    protected function compile()
    {
        if ($this->jumpTo) {
            $arrJahre = array();
            $arrLinks = array();

            $objJahre = $this->loadPublishedVolumes();
            if ($objJahre) {
                while ($objJahre->next()) {
                    $arrJahre[] = $objJahre->jahr;
                    $arrLinks[$this->getNavigationUrl($objJahre->jahr)] = $objJahre->jahr;
                }
            }

            $this->Template->jahre = $arrLinks;
            $this->Template->controlId = uniqid($this->strTemplate);

            if (count($arrJahre)) {
                $strJahr = \Input::get('items');
                if (!$strJahr) {
                    if (count($arrJahre) > 0) {
                        $strJahr = $arrJahre[0];
                    }
                } else {
                    if (!in_array($strJahr, $arrJahre)) {
                        if (count($arrJahre) > 0) {
                            $strJahr = $arrJahre[0];
                        }
                    }
                }
                $this->Template->jahr = $strJahr;
                $this->Template->hasNext = false;
                $this->Template->hasPrevious = false;

                $intCurrentIndex = array_search($strJahr, $arrJahre);
                if ($intCurrentIndex !== false) {
                    if ($intCurrentIndex > 0) {
                        $this->Template->hasNext = true;
                        $this->Template->next = $this->getNavigationUrl($arrJahre[$intCurrentIndex - 1]);
                    }
                    if ($intCurrentIndex != count($arrJahre) - 1) {
                        $this->Template->hasPrevious = true;
                        $this->Template->previous = $this->getNavigationUrl($arrJahre[$intCurrentIndex + 1]);
                    }
                }
            }
        }
    }
}
