<?php

namespace Tanzsport\ContaoTanzspiegelBundle;

class ModuleTanzspiegelImportBackend extends \BackendModule
{

    protected $strTemplate = 'be_ts_import';

    private $db;
    private $tsDs;

    public function __construct()
    {
        parent::__construct();
        $this->db = \Database::getInstance();
        $this->tsDs = new TanzspiegelDateisystem();
    }

    public function generate()
    {
        return parent::generate();
    }

    protected function compile()
    {
        if (\Input::post('td_ts_import')) {
            $this->importieren();
        }

        $this->Template->import = $this->findeNichtVorhandeneAusgaben();
        $this->Template->messages = \Message::generate();
        $this->Template->href = $this->getReferer(true);
        $this->Template->title = specialchars($GLOBALS['TL_LANG']['MSC']['backBTTitle']);
        $this->Template->button = $GLOBALS['TL_LANG']['MSC']['backBT'];
        $this->Template->action = ampersand(\Environment::get('request'));
        $this->Template->submitButton = specialchars($GLOBALS['TL_LANG']['MSC']['continue']);
        \Message::reset();
    }

    private function findeNichtVorhandeneAusgaben()
    {
        $arrFiles = $this->tsDs->findTitelbilder();
        if (count($arrFiles) > 0) {
            $objAusgaben = TanzspiegelAusgabeModel::findAll();
            if ($objAusgaben) {
                while ($objAusgaben->next()) {
                    $objAusgabe = $objAusgaben->current();
                    if (isset($arrFiles[$objAusgabe->identifier])) {
                        unset($arrFiles[$objAusgabe->identifier]);
                    }
                }
            }
        }
        arsort($arrFiles);
        $arrNichtImportiert = array();
        foreach ($arrFiles as $identifier => $objFile) {
            $objImport = new \stdClass();
            $objImport->identifier = $identifier;
            $objImport->name = TanzspiegelAusgabeModel::identifierToName($identifier);
            $arrNichtImportiert[] = $objImport;
        }
        return $arrNichtImportiert;
    }

    private function importieren()
    {
        $blnPublish = \Input::post('publish') > 0;
        $arrIdentifiers = \Input::post('identifier');
        if (!$arrIdentifiers) {
            \Message::addError('Keine Ausgaben zum Import ausgewählt!');
            return;
        }

        if (count($arrIdentifiers) > 0) {
            foreach ($arrIdentifiers as $identifier) {
                $objModel = TanzspiegelAusgabeModel::createNewFromIdentifier($identifier);
                if ($objModel !== false) {
                    if ($blnPublish) {
                        $objModel->published = 1;
                    }
                    $objModel->save();
                    \Message::addConfirmation(sprintf('Ausgabe %1$s importiert', TanzspiegelAusgabeModel::identifierToName($identifier)));
                }
            }
        }
    }
}
