<?php

namespace Tanzsport\ContaoTanzspiegelBundle;

use Contao\FrontendTemplate;
use Contao\StringUtil;

class ModuleTanzspiegelAusgaben extends ModuleTanzspiegel
{

    protected $strTemplate = 'mod_tanzspiegel_ausgaben';

    public function generate()
    {
        if (TL_MODE == 'BE') {
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### ' . $GLOBALS['TL_LANG']['FMD']['td_tanzspiegel_ausgaben'][0] . ' ###';
            $objTemplate->title = $this->headline;
            $objTemplate->id = $this->id;
            $objTemplate->link = $this->name;
            $objTemplate->href = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        if (!isset($_GET['items']) && $GLOBALS['TL_CONFIG']['useAutoItem'] && isset($_GET['auto_item'])) {
            \Input::setGet('items', \Input::get('auto_item'));
        }

        $this->loadLanguageFile('td_ts_fe');

        return parent::generate();
    }

    protected function compile()
    {
        $volumes = array_map(function ($item) {
            return $item['jahr'];
        }, $this->loadPublishedVolumes()->fetchAllAssoc());

        $requestedVolume = \Input::get('items');
        if (!$requestedVolume) {
            if (count($volumes) > 0) {
                $requestedVolume = $volumes[0];
            }
        } else {
            if (!in_array($requestedVolume, $volumes)) {
                if (count($volumes) > 0) {
                    $requestedVolume = $volumes[0];
                }
            }
        }

        $editionTemplateName = 'ts_ausgabe';
        if ($this->td_ts_template) {
            $editionTemplateName = $this->td_ts_template;
        }

        $parsedEditions = [];

        if ($requestedVolume) {
            $editions = $this->loadPublishedEditionsByYear($requestedVolume);
            if ($editions) {
                while ($editions->next()) {
                    /**
                     * @var TanzspiegelAusgabeModel $edition
                     */
                    $edition = $editions->current();
                    $editionTemplate = new FrontendTemplate($editionTemplateName);
                    $editionTemplate->placeholderSizeHtml = $this->getPlaceholderSizeHtml(StringUtil::deserialize($this->imgSize));
                    $coverImage = $edition->titelbild;
                    if ($this->td_ts_image && $coverImage) {
                        $editionTemplate->showImage = true;
                        $imageData = [];
                        $imageData['singleSRC'] = $coverImage->path;
                        $imageData['size'] = $this->imgSize;
                        // overwrite meta data set in the files model
                        $imageData['overwriteMeta'] = true;
                        $imageData['alt'] = $edition->ausgabe;
                        $imageData['imageTitle'] = $edition->ausgabe;
                        $this->addImageToTemplate($editionTemplate, $imageData, null, null, $coverImage);
                    }
                    $editionTemplate->ausgabe = $edition;
                    $parsedEditions[] = $editionTemplate->parse();
                }
            }
        }

        $this->Template->ausgaben = $parsedEditions;
    }

    private function getPlaceholderSizeHtml(array $imageSize = null)
    {
        $sizeHtml = null;
        if ($imageSize) {
            if ($imageSize[0] > 0) {
                $sizeHtml .= 'width:' . $imageSize[0] . "px;";
            }
            if ($imageSize[1] > 0) {
                $sizeHtml .= 'height:' . $imageSize[1] . "px;";
            }
            if ($sizeHtml) {
                return 'style="' . $sizeHtml . '"';
            }
        }
    }

}
