<?php

namespace Tanzsport\ContaoTanzspiegelBundle;

use Contao\PageModel;

abstract class ModuleTanzspiegel extends \Module
{

    protected function getJumpToUrl()
    {
        if ($this->jumpTo && ($objPage = PageModel::findByPk($this->jumpTo)) != null) {
            return $objPage->getFrontendUrl();
        }
    }

    protected function getNavigationUrl($strJahr)
    {
        $strUrl = $this->getJumpToUrl();
        if ($strUrl) {
            return $strUrl . ($GLOBALS['TL_CONFIG']['useAutoItem'] ? '/' : '/items/') . $strJahr;
        }
    }

    protected function loadPublishedEditionsByYear(int $year)
    {
        if ($year) {
            return TanzspiegelAusgabeModel::findBy(array("jahr = $year", 'published = 1'), null, array('order' => 'jahr DESC, monat DESC'));
        }
    }

    protected function loadPublishedVolumes()
    {
        return $this->Database->prepare('SELECT DISTINCT jahr FROM ' . TanzspiegelAusgabeModel::getTable() . ' WHERE published = ? ORDER BY 1 DESC')->execute(1);
    }

}
