<?php

namespace Tanzsport\ContaoTanzspiegelBundle;

use Database\Result;

/**
 * Class TanzspiegelAusgabeModel
 * @package Tanzsport\ContaoTanzspiegelBundle
 *
 * @property-read string $ausgabe
 * @property-read TanzspiegelDownload[] $artikel
 * @property-read TanzspiegelDownloadGebietsteil[] $gebietsteile
 * @property-read bool $hasImage
 * @property-read string $identifier
 * @property-read string $name
 * @property-read FilesModel|null $titelbild
 */
class TanzspiegelAusgabeModel extends \Model
{

    protected static $strTable = "tl_td_ts";

    private $arrImgSize;
    private $strSizeHtml;

    private $objTitelbildCache = null;
    private $arrGebietsteileCache = array();
    private $arrArtikelCache = array();

    private $tsDs;

    public function __construct(Result $objResult = null)
    {
        parent::__construct($objResult);
        $this->tsDs = new TanzspiegelDateisystem();
    }


    public function __get($key)
    {
        switch ($key) {
            case 'ausgabe':
                return $this->getAusgabe();
            case 'artikel':
                return $this->getArtikel();
            case 'gebietsteile':
                return $this->getGebietsteile();
            case 'hasImage':
                return $this->getHasImage();
            case 'identifier':
                return $this->getIdentifier();
            case 'name':
                return $this->getName();
            case 'titelbild':
                return $this->getTitelbild();
            default:
                return parent::__get($key);
        }
    }

    public function prepareImage($imgSize)
    {
        $this->arrImgSize = deserialize($imgSize);
    }

    private function formatJahr()
    {
        return sprintf('%1$d', $this->jahr);
    }

    private function formatMonat()
    {
        return sprintf('%1$02d', $this->monat);
    }

    private function formatDatum()
    {
        return sprintf('%1$d-%2$02d-%3$02d', $this->jahr, $this->monat, 1);
    }

    private function getAusgabe()
    {
        return sprintf('%1$s %2$s', $GLOBALS['TL_LANG']['td_ts_fe']['ausgabe'], $this->name);
    }

    private function getIdentifier()
    {
        return sprintf('%1$s-%2$s', $this->formatJahr(), $this->formatMonat());
    }

    private function getName()
    {
        return \Date::parse('F Y', strtotime($this->formatDatum()));
    }

    public static function identifierToName($identifier)
    {
        return \Date::parse('F Y', strtotime($identifier . '-01'));
    }

    public static function createNewFromIdentifier($identifier)
    {
        $arrTokens = explode('-', $identifier);
        if (count($arrTokens) == 2) {
            $objModel = self::findBy(array('jahr = ? AND monat = ?'), array($arrTokens[0], $arrTokens[1]));
            if (!$objModel) {
                $objModel = new TanzspiegelAusgabeModel();
                $objModel->jahr = $arrTokens[0];
                $objModel->monat = $arrTokens[1];
                return $objModel;
            }
        }

        return false;
    }

    private function getHasImage()
    {
        $objImage = $this->getTitelbild();
        if ($objImage != null) {
            return $objImage->found;
        }
        return false;
    }

    // artikel //

    private function getArtikel()
    {
        if ($this->arrArtikelCache == null) {
            $this->arrArtikelCache = $this->tsDs->findArtikel($this->formatJahr(), $this->formatMonat());
        }

        return $this->arrArtikelCache;
    }

    // gebietsteile //

    private function getGebietsteile()
    {
        if ($this->arrGebietsteileCache == null) {
            $this->arrGebietsteileCache = $this->tsDs->findGebietsteile($this->formatJahr(), $this->formatMonat());
        }

        return $this->arrGebietsteileCache;
    }

    // titelbild //

    private function getTitelbild()
    {
        if ($this->objTitelbildCache == null) {
            $this->objTitelbildCache = $this->tsDs->findTitelbild($this->formatJahr(), $this->formatMonat());
        }
        return $this->objTitelbildCache;
    }
}
