<?php

$GLOBALS['TL_DCA']['tl_td_ts'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'enableVersioning' => true,
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'jahr,monat' => 'unique',
            )
        ),
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 1,
            'fields' => array('jahr DESC', 'monat'),
            'flag' => 12,
            'panelLayout' => 'sort,filter;search,limit',
            'disableGrouping' => false,
        ),
        'label' => array
        (
            'fields' => array('jahr', 'monat'),
            'format' => '%2$s %1$d',
        ),
        'global_operations' => array
        (
            'all' => array
            (
                'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
                'href' => 'act=select',
                'class' => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_ts']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.gif'
            ),
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_ts']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.gif',
                'attributes' => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"'
            ),
            'toggle' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_ts']['toggle'],
                'icon' => 'visible.gif',
                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
                'button_callback' => array('tl_td_ts', 'toggleIcon')
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_ts']['show'],
                'href' => 'act=show',
                'icon' => 'show.gif'
            )
        )
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array(''),
        'default' => '{ausgabe_legend},jahr,monat;{veroeffentlichung_legend},published'
    ),

    // Subpalettes
    'subpalettes' => array
    (
        '' => ''
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'jahr' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_td_ts']['jahr'],
            'filter' => true,
            'flag' => 12,
            'inputType' => 'text',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
            'sql' => "int(4) NOT NULL default '0'"
        ),
        'monat' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_td_ts']['monat'],
            'filter' => true,
            'flag' => 12,
            'inputType' => 'select',
            'options' => array(
                '1' => 'Januar',
                '2' => 'Februar',
                '3' => 'März',
                '4' => 'April',
                '5' => 'Mai',
                '6' => 'Juni',
                '7' => 'Juli',
                '8' => 'August',
                '9' => 'September',
                '10' => 'Oktober',
                '11' => 'November',
                '12' => 'Dezember'
            ),
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50', 'chosen' => true),
            'sql' => "int(1) NOT NULL default '1'"
        ),
        'published' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_td_ts']['published'],
            'filter' => false,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
            'sql' => "char(1) NOT NULL default ''"
        ),
    ),

);

class tl_td_ts extends Backend
{

    public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (strlen(Input::get('tid'))) {
            $this->toggleVisibility(Input::get('tid'), (Input::get('state') == 1));
            $this->redirect($this->getReferer());
        }

        $href .= '&amp;tid=' . $row['id'] . '&amp;state=' . ($row['published'] ? '' : 1);

        if (!$row['published']) {
            $icon = 'invisible.gif';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '"' . $attributes . '>' . Image::getHtml($icon, $label) . '</a> ';
    }

    public function toggleVisibility($intId, $blnVisible)
    {
        $objVersions = new Versions('tl_td_ts', $intId);
        $objVersions->initialize();

        if (is_array($GLOBALS['TL_DCA']['tl_td_ts']['fields']['published']['save_callback'])) {
            foreach ($GLOBALS['TL_DCA']['tl_td_ts']['fields']['published']['save_callback'] as $callback) {
                if (is_array($callback)) {
                    $this->import($callback[0]);
                    $blnVisible = $this->$callback[0]->$callback[1]($blnVisible, $this);
                } elseif (is_callable($callback)) {
                    $blnVisible = $callback($blnVisible, $this);
                }
            }
        }

        // Update the database
        $this->Database->prepare("UPDATE tl_td_ts SET tstamp=" . time() . ", published='" . ($blnVisible ? 1 : '') . "' WHERE id=?")
            ->execute($intId);

        $objVersions->create();
    }
}
