<?php

namespace Tanzsport\ContaoTanzspiegelBundle;

class TanzspiegelDownloadGebietsteil extends TanzspiegelDownload
{

    private $strRegex = '/.*_(nord|ost|sued|west).pdf/i';

    protected function getLink()
    {
        $strLink = $this->getMetaField('title');
        if (!$strLink) {
            $strLink = $this->getGebietsteilName($this->basename);
        }
        return $strLink;
    }

    private function getGebietsteilName($strFileName)
    {
        $arrMatches = array();
        if (preg_match($this->strRegex, $strFileName, $arrMatches)) {
            if ($arrMatches) {
                return $GLOBALS['TL_LANG']['td_ts_fe']['gebietsteile'][strtolower($arrMatches[1])];
            }
        } else {
            return $strFileName;
        }
    }
}
