<?php

namespace Tanzsport\ContaoTanzspiegelBundle;

use \Contao\StringUtil;

class TanzspiegelDownload extends \System
{

    private $objModel;
    private $objFile;

    public function __construct(\FilesModel $objModel)
    {
        $this->objModel = $objModel;
        $this->objFile = new \File($objModel->path);

        $this->loadLanguageFile('td_ts_fe');
    }

    public function __get($key)
    {
        switch ($key) {
            case 'filesize':
                return $this->getFilesize();
            case 'href':
                return $this->getHref();
            case 'link':
                return $this->getLink();
            case 'title':
                return $this->getTitle();
            case 'file';
                return $this->objFile->name;
            default:
                return $this->objFile->$key;
        }
    }

    private function getFilesize()
    {
        return $this->getReadableSize($this->objFile->filesize, 1);
    }

    private function getFrontendLanguage()
    {
        if (isset($GLOBALS['TL_LANGUAGE'])) {
            return $GLOBALS['TL_LANGUAGE'];
        } else {
            return 'de';
        }
    }

    private function getHref()
    {
        return \System::urlEncode($this->objFile->value);
    }

    protected function getLink()
    {
        $strLink = $this->getMetaField('title');
        if (!$strLink) {
            $strLink = $this->objFile->basename;
        }
        return $strLink;
    }

    public function getMetaField($field)
    {
        $arrMeta = StringUtil::deserialize($this->objModel->meta, true);
        $strLanguage = $this->getFrontendLanguage();
        if (isset($arrMeta[$strLanguage])) {
            if (isset($arrMeta[$strLanguage][$field])) {
                return $arrMeta[$strLanguage][$field];
            }
        }
    }

    private function getTitle()
    {
        return StringUtil::specialchars(sprintf($GLOBALS['TL_LANG']['MSC']['download'], $this->objFile->basename));
    }
}
