<?php

namespace Tanzsport\ContaoTanzspiegelBundle;

use FilesModel;

class TanzspiegelDateisystem
{

    private $strVerzeichnisGebietsteile;
    private $strVerzeichnisMantel;
    private $strVerzeichnisTitel;

    public function __construct()
    {
        $this->strVerzeichnisGebietsteile = $this->removeTrailingSlash(sprintf('%1$s/%2$s', $this->getUploadPath(), \Config::get('td_ts_gebietsteileverzeichnis')));
        $this->strVerzeichnisMantel = $this->removeTrailingSlash(sprintf('%1$s/%2$s', $this->getUploadPath(), \Config::get('td_ts_mantelverzeichnis')));
        $this->strVerzeichnisTitel = $this->removeTrailingSlash(sprintf('%1$s/%2$s', $this->getUploadPath(), \Config::get('td_ts_titelverzeichnis')));
    }

    /**
     * @param $intJahr
     * @param $intMonat
     * @return TanzspiegelDownload[]
     */
    public function findArtikel($intJahr, $intMonat)
    {
        $arrArtikel = array();
        $strArtikelPfad = sprintf('%1$s/%2$s', $this->getVerzeichnisMantel(), $intJahr);
        $objFiles = FilesModel::findMultipleFilesByFolder($strArtikelPfad);
        if ($objFiles) {
            $strRegex = sprintf('/%1$s_%2$02d_\w+.pdf/i', $intJahr, $intMonat);
            while ($objFiles->next()) {
                $objFile = $objFiles->current();
                if (preg_match($strRegex, $objFile->name)) {
                    $arrArtikel[] = new TanzspiegelDownload($objFile);
                }
            }
        }
        return $arrArtikel;
    }

    /**
     * @return string[]
     */
    public function findJahre()
    {
        $arrJahre = array();
        $t = FilesModel::getTable();
        $strPath = str_replace(array('%', '_'), array('\\%', '\\_'), $this->getVerzeichnisTitel());
        $objFiles = FilesModel::findBy(array("$t.type='folder' AND $t.path LIKE ? AND $t.path NOT LIKE ?"), array($strPath . '/%', $strPath . '/%/%'));
        if ($objFiles) {
            while ($objFiles->next()) {
                $objFile = $objFiles->current();
                if (preg_match('/\d{4}/', $objFile->name)) {
                    if (!in_array($objFile->name, $arrJahre)) {
                        $arrJahre[] = $objFile->name;
                    }
                }
            }
        }
        rsort($arrJahre);
        return $arrJahre;
    }

    /**
     * @param $intJahr
     * @param $intMonat
     * @return TanzspiegelDownloadGebietsteil[]
     */
    public function findGebietsteile($intJahr, $intMonat)
    {
        $arrGebiesteile = array();
        $strGebietsteilePfad = sprintf('%1$s/%2$s', $this->getVerzeichnisGebietsteile(), $intJahr);
        $objFiles = FilesModel::findMultipleFilesByFolder($strGebietsteilePfad);
        if ($objFiles) {
            $strRegex = sprintf('/%1$s_%2$02d_(nord|ost|sued|west).pdf/i', $intJahr, $intMonat);
            while ($objFiles->next()) {
                $objFile = $objFiles->current();
                if (preg_match($strRegex, $objFile->name)) {
                    $arrGebiesteile[] = new TanzspiegelDownloadGebietsteil($objFile);
                }
            }
        }
        usort($arrGebiesteile, array($this, 'sortGebietsteile'));
        return $arrGebiesteile;
    }

    public function sortGebietsteile($a, $b)
    {
        $search = array('nord', 'west', 'ost', 'sued');
        $repl = array('1', '2', '3', '4');
        return strcmp(str_replace($search, $repl, $a->file), str_replace($search, $repl, $b->file));
    }

    public function findTitelbild($intJahr, $intMonat)
    {
        $strTitelbild = sprintf('%1$s/%2$s/ts-%2$s-%3$02d.jpg', $this->getVerzeichnisTitel(), $intJahr, $intMonat);
        return FilesModel::findOneBy('path', $strTitelbild);
    }

    /**
     * @return FilesModel[]
     */
    public function findTitelbilder()
    {
        $arrTitelbilder = array();
        $t = FilesModel::getTable();
        $strPath = str_replace(array('%', '_'), array('\\%', '\\_'), $this->getVerzeichnisTitel());
        $objFiles = FilesModel::findBy(array("$t.type='file' AND $t.path LIKE ?"), $strPath . '/%');
        if ($objFiles) {
            while ($objFiles->next()) {
                $objFile = $objFiles->current();
                $arrMatches = array();
                if (preg_match('/ts-(\d{4}-\d{2}).jpg/i', $objFile->name, $arrMatches)) {
                    $arrTitelbilder[$arrMatches[1]] = $objFile;
                }
            }
        }
        return $arrTitelbilder;
    }

    private function getUploadPath()
    {
        return \Config::get('uploadPath');
    }

    private function getVerzeichnisMantel()
    {
        return $this->strVerzeichnisMantel;
    }

    private function getVerzeichnisGebietsteile()
    {
        return $this->strVerzeichnisGebietsteile;
    }

    private function getVerzeichnisTitel()
    {
        return $this->strVerzeichnisTitel;
    }

    private function removeTrailingSlash($strInput)
    {
        if ($strInput) {
            if (strrpos($strInput, '/') == strlen($strInput) - 1) {
                return substr($strInput, 0, strrpos($strInput, '/'));
            } else {
                return $strInput;
            }
        }
    }
}
