<?php

namespace Tanzsport;

use Contao\BackendTemplate;
use Contao\Widget;

class WertungsrichterWidget extends Widget
{

    /**
     * Submit user input
     * @var boolean
     */
    protected $blnSubmitInput = true;

    /**
     * Template
     * @var string
     */
    protected $strTemplate = 'be_widget';

    /**
     * @var Ergebnisarchiv
     */
    private $ergebnisarchiv;

    public function __construct($arrAttributes = null)
    {
        parent::__construct($arrAttributes);
        $this->ergebnisarchiv = new Ergebnisarchiv();
    }

    /**
     * Generate the widget and return it as string
     *
     * @return string The widget markup
     */
    public function generate()
    {
        $template = new BackendTemplate('widget_wertungsrichter');
        $template->strId = $this->strId;
        $template->wertungsrichter_anzahl = $this->activeRecord->wertungsrichter_anzahl;
        $template->landesverbaende = $this->ergebnisarchiv->getLandesverbaende();

        if (!$this->varValue) {
            $initialValue = array();
            for ($i = 0; $i < $this->activeRecord->wertungsrichter_anzahl; $i++) {
                $initialValue[] = array('name' => '', 'verein' => '', 'ltv' => '');
            }
            $this->varValue = $initialValue;
        }
        $template->value = $this->varValue;

        return $template->parse();
    }


    public static function saveCallback($value, \DC_Table $dc)
    {
        return $value;
    }

    protected function validator($varInput)
    {
        if (!$varInput) {
            $this->addError("Keine Wertungsrichter erfasst!");
            return $varInput;
        }
        if (count($varInput) != $this->activeRecord->wertungsrichter_anzahl) {
            $this->addError("Es müssen {$this->activeRecord->wertungsrichter_anzahl} erfasst werden!");
            return $varInput;
        }

        $errors = array();
        foreach ($varInput as $i => $wr) {
            $wrErrors = array();
            if (!$wr['name']) {
                $wrErrors[] = "Name fehlt";
            }
            if (!$wr['verein']) {
                $wrErrors[] = "Verein fehlt";
            }
            if (!$wr['ltv']) {
                $wrErrors[] = "LTV fehlt";
            }
            if (count($wrErrors)) {
                $wrKuerzel = chr(65 + $i);
                $errors[] = "WR {$wrKuerzel}: " . implode(' / ', $wrErrors);
            }
        }
        if (count($errors)) {
            $this->addError("Fehler (weitere Informationen beim Überfahren mit der Maus):<br/>" . implode('<br>', $errors));
        }
        return $varInput;
    }

}
