<?php

namespace Tanzsport;

use Contao\System;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class ModuleMannschaftsdatenMelden extends \Module
{

    protected $strTemplate = 'mod_mannschaftsdaten_melden';

    public function generate()
    {
        if (TL_MODE == 'BE') {
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### ' . utf8_strtoupper($GLOBALS['TL_LANG']['FMD']['td_mannschaftsdaten_melden'][0]) . ' ###';
            $objTemplate->title = $this->headline;
            $objTemplate->id = $this->id;
            $objTemplate->link = $this->name;
            $objTemplate->href = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        return parent::generate();
    }

    protected function compile()
    {
        $GLOBALS['TL_JAVASCRIPT'][] = 'bundles/contaoformationen/components/sweetalert/dist/sweetalert.min.js|static';
        $GLOBALS['TL_JAVASCRIPT'][] = 'bundles/contaoformationen/components/angular/angular.min.js|static';
        $GLOBALS['TL_JAVASCRIPT'][] = 'bundles/contaoformationen/components/angular-route/angular-route.min.js|static';
        $GLOBALS['TL_JAVASCRIPT'][] = 'bundles/contaoformationen/components/angular-resource/angular-resource.min.js|static';
        $GLOBALS['TL_JAVASCRIPT'][] = 'bundles/contaoformationen/js/mannschaftsdaten/melden.js|static';

        $GLOBALS['TL_CSS'][] = 'bundles/contaoformationen//components/sweetalert/dist/sweetalert.css|static';

        /**
         * @var $router UrlGeneratorInterface
         */
        $router = System::getContainer()->get('router');

        $routes = [
            'ligen' => $router->generate('td.formationen.mannschaftsdaten.ligen', ['module' => $this->id]),
            'mannschaften' => $router->generate('td.formationen.mannschaftsdaten.mannschaften'),
            'melden' => $router->generate('td.formationen.mannschaftsdaten.melden')
        ];

        $this->Template->routes = (object)$routes;
    }

}
