<?php

namespace Tanzsport;

class ModuleErgebnisarchivSaison extends ModuleErgebnisarchiv
{

    protected $strTemplate = 'mod_ergebnisarchiv_saison';

    private $intJahr;
    private $strBereich;
    private $strLiga;
    private $strTurnierart;
    private $intNr;

    private $intTurnier;

    public function generate()
    {
        if (TL_MODE == 'BE') {
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### ' . utf8_strtoupper($GLOBALS['TL_LANG']['FMD']['td_ergebnisarchiv_saison'][0]) . ' ###';
            $objTemplate->title = $this->headline;
            $objTemplate->id = $this->id;
            $objTemplate->link = $this->name;
            $objTemplate->href = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        if (!isset($_GET['items']) && $GLOBALS['TL_CONFIG']['useAutoItem'] && isset($_GET['auto_item'])) {
            \Input::setGet('items', \Input::get('auto_item'));
            $this->parseItems();
        } else {
            $this->parseQueryString();
        }

        return parent::generate();
    }

    protected function compile()
    {
        global $objPage;

        \System::loadLanguageFile('tl_td_erg');

        $arrTurnierarten = deserialize($this->td_erg_turnierarten, true);

        if ($this->intTurnier > 0) {
            $objTurnier = FreiesturnierModel::findByPk($this->intTurnier);
            $this->intJahr = $objTurnier->saison->jahr;
            $strSaisonTitel = null;

            if (in_array(Ergebnisarchiv::TURNIERART_JMD, $arrTurnierarten)) {
                $strSaisonTitel = $this->intJahr;
                $this->Template->jmd = true;
            } else {
                $intJahrVorher = $this->intJahr - 1;
                $strSaisonTitel = $intJahrVorher . '/' . $this->intJahr;
                $this->Template->jmd = false;
            }
            $objPage->title = $objPage->title . ' ' . $strSaisonTitel;
            $this->Template->saisonTitel = $strSaisonTitel;

            $this->Template->turnier = $objTurnier;
            $this->Template->abgelaufen = $objTurnier->saisonAbgelaufen;
            $this->Template->mannschaften = FreiesturnierMannschaftModel::findPublishedByTurnierOrderByStartnr($objTurnier->id);
            $this->Template->turniere = [$objTurnier];
            $this->Template->dateFormat = $this->getDateFormat();
            if ($this->Template->mannschaften != null && $this->Template->turniere != null) {
                $this->Template->tabelle = new FreiesturnierergebnisTabelle($this->Template->mannschaften, $this->Template->turniere);
            }
            if ($this->hl) {
                $this->Template->hl2 = preg_replace_callback('/h(\d)/', function ($matches) {
                    return 'h' . ($matches[1] + 1);
                }, $this->hl);
                $this->Template->hl3 = preg_replace_callback('/h(\d)/', function ($matches) {
                    return 'h' . ($matches[1] + 2);
                }, $this->hl);
            } else {
                $this->Template->hl2 = 'h1';
                $this->Template->hl3 = 'h2';
            }
        } else {
            if (!$this->intJahr) {
                $this->Template->saisons = $this->getVeroeffentlichteSaisons($arrTurnierarten);
                $this->Template->renderLink = $this->renderLinkJahr();
                $this->Template->jmd = in_array(Ergebnisarchiv::TURNIERART_JMD, $arrTurnierarten);
            } else {
                $strSaisonTitel = null;
                if (in_array(Ergebnisarchiv::TURNIERART_JMD, $arrTurnierarten)) {
                    $strSaisonTitel = $this->intJahr;
                } else {
                    $intJahrVorher = $this->intJahr - 1;
                    $strSaisonTitel = $intJahrVorher . '/' . $this->intJahr;
                }
                $objPage->title = $objPage->title . ' ' . $strSaisonTitel;
                $this->Template->saisonTitel = $strSaisonTitel;

                if (!$this->strBereich) {
                    $this->Template->jahr = $this->intJahr;
                    $this->Template->bereiche = $this->getVeroffentlichteBereicheUndLigenUndTurniere($arrTurnierarten, $this->intJahr);
                } else {
                    $objLiga = LigaModel::findOnePublishedByJahrBereichLigaTurnierart($this->intJahr, $this->strBereich, $this->strLiga, $this->strTurnierart, $this->intNr);

                    if ($objLiga->turnierart == Ergebnisarchiv::TURNIERART_JMD) {
                        $this->Template->jmd = true;
                    } else {
                        $this->Template->jmd = false;
                    }
                    $this->Template->liga = $objLiga;
                    $this->Template->abgelaufen = $objLiga->saisonAbgelaufen;
                    $this->Template->mannschaften = LigaMannschaftModel::findPublishedByLigaOrderByStartnr($objLiga->id);
                    $this->Template->turniere = LigaTurnierModel::findPublishedByLigaOrderByDatum($objLiga->id);
                    $this->Template->dateFormat = $this->getDateFormat();
                    if ($this->Template->mannschaften != null && $this->Template->turniere != null) {
                        $this->Template->tabelle = new LigaergebnisTabelle($this->Template->mannschaften, $this->Template->turniere);
                    }
                    if ($this->hl) {
                        $this->Template->hl2 = preg_replace_callback('/h(\d)/', function ($matches) {
                            return 'h' . ($matches[1] + 1);
                        }, $this->hl);
                        $this->Template->hl3 = preg_replace_callback('/h(\d)/', function ($matches) {
                            return 'h' . ($matches[1] + 2);
                        }, $this->hl);
                    } else {
                        $this->Template->hl2 = 'h1';
                        $this->Template->hl3 = 'h2';
                    }
                }
            }
        }

        $this->Template->back = $GLOBALS['TL_LANG']['MSC']['goBack'];
    }

    private function parseItems()
    {
        $arrItems = preg_split('/\-/', \Input::get('items'));
        if (count($arrItems)) {
            if (in_array('turnier', $arrItems)) {
                $this->intTurnier = intval($arrItems[1]);
            } else {
                $this->intJahr = intval($arrItems[0]);
                if (isset($arrItems[1])) {
                    $this->strBereich = $arrItems[1];
                }
                if (isset($arrItems[2])) {
                    $this->strLiga = $arrItems[2];
                }
                if (isset($arrItems[3])) {
                    $this->strTurnierart = $arrItems[3];
                }
                if (isset($arrItems[4])) {
                    $this->intNr = intval($arrItems[4]);
                }
            }
        }
    }

    private function parseQueryString()
    {
        if (\Input::get('turnier') != null) {
            $this->intTurnier = intval(\Input::get('turnier'));
        } else {
            $this->intJahr = intval(\Input::get('jahr'));
            $this->strBereich = \Input::get('bereich');
            $this->strLiga = \Input::get('liga');
            $this->strTurnierart = \Input::get('turnierart');
            $this->intNr = \Input::get('nr') != null ? intval(\Input::get('nr')) : null;
        }
    }

    private function renderLinkJahr()
    {
        return function ($jahr, $jmd) {
            $intJahrVorher = $jahr - 1;
            $strText = $jmd ? $jahr : $intJahrVorher . '/' . $jahr;
            if ($GLOBALS['TL_CONFIG']['useAutoItem']) {
                return sprintf('<a href="{{env::request}}/%1$s">%2$s</a>', $jahr, $strText);
            } else {
                return sprintf('<a href="{{env::request}}/?jahr=%1$s">%2$s</a>', $jahr, $strText);
            }
        };
    }

}
