<?php

namespace Tanzsport;

use \FrontendTemplate;

abstract class ModuleErgebnisarchivLigabereich extends ModuleErgebnisarchiv
{

    public function generate()
    {
        if (TL_MODE == 'BE') {
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### ' . utf8_strtoupper($GLOBALS['TL_LANG']['FMD'][$this->getFrontendModuleId()][0]) . ' ###';
            $objTemplate->title = $this->headline;
            $objTemplate->id = $this->id;
            $objTemplate->link = $this->name;
            $objTemplate->href = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        return parent::generate();
    }

    /**
     * @return string
     */
    protected abstract function getFrontendModuleId();

    /**
     * @return string
     */
    protected abstract function getTypId();

    /**
     * @return string
     */
    protected abstract function getImageMapTemplate();

    /**
     * @return array
     */
    protected abstract function getLigabereichIds();

    /**
     * @return array
     */
    protected function getMappedLigabereiche()
    {
        return [];
    }

    protected function loadLigabereiche(SaisonModel $objSaison = null)
    {
        $arrLigabereiche = [];
        $objTargetPage = $this->getTargetPage();
        if ($objSaison != null) {
            foreach ($this->getLigabereichIds() as $strLigabereichId) {
                $objLigabereich = new \stdClass();
                $objLigabereich->id = $strLigabereichId;
                $objLigabereich->name = &$GLOBALS['TL_LANG'][Ergebnisarchiv::LNG_KEY]['public'][$strLigabereichId];

                // ligen
                $objLigen = LigaModel::findPublishedBySaisonAndLigabereich($objSaison, $strLigabereichId);
                $arrLigen = [];
                if ($objLigen != null) {
                    while ($objLigen->next()) {
                        $objLiga = $objLigen->current();
                        $arrLigen[] = $this->renderLinkLiga($objSaison->jahr, $objLiga, $objTargetPage);
                    }
                }
                $objLigabereich->ligen = $arrLigen;

                // turniere
                $objTurniere = FreiesturnierModel::findPublishedBySaisonAndLigabereich($objSaison, $strLigabereichId);
                $arrTurniere = [];
                if ($objTurniere != null) {
                    while ($objTurniere->next()) {
                        $objTurnier = $objTurniere->current();
                        $arrTurniere[] = $this->renderLinkTurnier($objTurnier, $objTargetPage);
                    }
                }
                $objLigabereich->turniere = $arrTurniere;

                // saisoninfo
                $objSaisonInfo = SaisonInfoModel::findOneBySaisonAndLigabereich($objSaison, $strLigabereichId);
                if ($objSaisonInfo != null) {
                    $objLigabereich->info = $objSaisonInfo->info;
                }

                $arrLigabereiche[$strLigabereichId] = $objLigabereich;
            }
        }

        $arrMappings = $this->getMappedLigabereiche();
        if (count($arrMappings) > 0) {
            foreach ($arrMappings as $strMappedBereich => $arrMappedTo) {
                if (isset($arrLigabereiche[$strMappedBereich])) {
                    foreach ($arrMappedTo as $strMappedTo) {
                        if (isset($arrLigabereiche[$strMappedTo])) {
                            $arrLigabereiche[$strMappedTo]->ligen = array_merge($arrLigabereiche[$strMappedTo]->ligen, $arrLigabereiche[$strMappedBereich]->ligen);
                        }
                    }
                }
                unset($arrLigabereiche[$strMappedBereich]);
            }
        }

        return $arrLigabereiche;
    }

    /**
     * @return null|\PageModel
     */
    protected function getTargetPage()
    {
        if ($this->jumpTo) {
            return \PageModel::findByPk($this->jumpTo);
        }
    }

    protected function compile()
    {
        \System::loadLanguageFile('tl_td_erg');

        $this->Template->typ = $this->getTypId();
        $strImageMapTemplate = $this->getImageMapTemplate();
        if ($strImageMapTemplate) {
            $objImageMapTemplate = new FrontendTemplate($strImageMapTemplate);
            $objImageMapTemplate->typ = $this->getTypId();
            $this->Template->imageMap = $objImageMapTemplate->parse();
        }
        $objSaison = SaisonModel::findLatestPublished();
        $this->Template->ligabereiche = $this->loadLigabereiche($objSaison);
        if ($this->getTypId() == 'F') {
            $intJahrVorher = $objSaison->jahr - 1;
            $this->Template->saisonTitel = $intJahrVorher . '/' . $objSaison->jahr;
        } else {
            $this->Template->saisonTitel = $objSaison->jahr;
        }
    }

}
