<?php

namespace Tanzsport;

abstract class ModuleErgebnisarchiv extends \Module
{
    protected function getDateFormat()
    {
        global $objPage;

        return $objPage->dateFormat;
    }

    /**
     * L&auml;dt alle Ligabereiche (inkl. Ligen) mit ver&ouml;ffentlichten Ligen und Mannschaften f&uuml;r das
     * angegebene Jahr.
     *
     * @param array $arrTurnierarten Turnierarten
     * @param $jahr Jahr
     * @return array
     */
    protected function getVeroffentlichteBereicheUndLigenUndTurniere(array $arrTurnierarten, $jahr)
    {
        if ($jahr == null) {
            throw new \InvalidArgumentException("Jahr erforderlich!");
        }

        \System::loadLanguageFile('tl_td_erg');

        $arrBereiche = array();

        $tl = LigaModel::getTable();
        $ts = SaisonModel::getTable();
        $tm = LigaMannschaftModel::getTable();
        $ft = FreiesturnierModel::getTable();
        $fm = FreiesturnierMannschaftModel::getTable();

        // ligen laden
        $strSql = "SELECT DISTINCT l.id, l.bereich, l.liga, l.turnierart, l.nr, l.bezeichnung, l.text FROM $tl l INNER JOIN $ts s ON s.id = l.pid INNER JOIN $tm m ON m.pid = l.id
			WHERE l.published = ? AND s.published = ? AND m.published = ?";
        if (!empty($arrTurnierarten)) {
            $strSql .= " AND l.turnierart IN (";
            $strSql .= implode(', ', array_fill(0, count($arrTurnierarten), '?'));
            $strSql .= ")";
        }
        $strSql .= " AND s.jahr = ?";
        $strSql .= " ORDER BY l.bereichOrder, l.ligaOrder, l.turnierartOrder, l.nr";

        $objResult = $this->Database->prepare($strSql)->execute(array_merge(array(1, 1, 1), $arrTurnierarten, [$jahr]));
        while ($objResult->next()) {
            $objData = new \stdClass();
            $objData->link = $this->renderLinkLiga($jahr, $objResult);

            if (!isset($arrBereiche[$objResult->bereich])) {
                $arrBereiche[$objResult->bereich] = array();
                $arrBereiche[$objResult->bereich]['label'] = &$GLOBALS['TL_LANG'][\Tanzsport\Ergebnisarchiv::LNG_KEY]['public'][$objResult->bereich];
                $arrBereiche[$objResult->bereich]['ligen'] = array();
                $arrBereiche[$objResult->bereich]['turniere'] = array();
            }

            $arrBereiche[$objResult->bereich]['ligen'][] = $objData;
        }

        // freie turniere
        $strSql = "SELECT DISTINCT t.id, t.bereich, t.datum, t.titel FROM $ft t INNER JOIN $ts s ON s.id = t.pid WHERE t.turnier_published = ? and s.published = ?";
        $strSql .= " AND s.jahr = ?";
        if (!empty($arrTurnierarten)) {
            $strSql .= " AND t.turnierart IN (";
            $strSql .= implode(', ', array_fill(0, count($arrTurnierarten), '?'));
            $strSql .= ")";
        }
        $strSql .= " ORDER BY t.bereichOrder, t.datum, t.titel";
        $objResult = $this->Database->prepare($strSql)->execute(array_merge(array(1, 1), [$jahr], $arrTurnierarten));
        while ($objResult->next()) {
            $objData = new \stdClass();
            $objData->link = $this->renderLinkTurnier($objResult);

            if (!isset($arrBereiche[$objResult->bereich])) {
                $arrBereiche[$objResult->bereich] = array();
                $arrBereiche[$objResult->bereich]['label'] = &$GLOBALS['TL_LANG'][\Tanzsport\Ergebnisarchiv::LNG_KEY]['public'][$objResult->bereich];
                $arrBereiche[$objResult->bereich]['turniere'] = array();
            }

            $arrBereiche[$objResult->bereich]['turniere'][] = $objData;
        }

        return $arrBereiche;
    }

    /**
     * L&auml;dt alle veröffentlichten Saisons der angegebenen Turnierarten mit ver&ouml;ffentlichten Ligen und
     * Mannschaften.
     *
     * @param array $arrTurnierarten Turnierarten
     * @param string $order Sortierreihenfolge (ASC, DESC)
     * @return array
     */
    protected function getVeroeffentlichteSaisons(array $arrTurnierarten, $order = 'DESC')
    {
        \System::loadLanguageFile('tl_td_erg');

        $arrJahre = array();

        $ts = SaisonModel::getTable();
        $tl = LigaModel::getTable();
        $tm = LigaMannschaftModel::getTable();
        $strSql = "SELECT DISTINCT s.jahr FROM $ts s INNER JOIN $tl l ON l.pid = s.id INNER JOIN $tm m ON m.pid = l.id
			WHERE s.published = ? AND l.published = ? AND m.published = ?";
        if (!empty($arrTurnierarten)) {
            $strSql .= " AND l.turnierart IN (";
            $strSql .= implode(', ', array_fill(0, count($arrTurnierarten), '?'));
            $strSql .= ")";
        }
        $strSql .= " ORDER BY 1 {$order}";

        $objResult = $this->Database->prepare($strSql)->execute(array_merge(array(1, 1, 1), $arrTurnierarten));
        while ($objResult->next()) {
            $arrJahre[] = $objResult->jahr;
        }

        return $arrJahre;
    }

    protected function renderLinkLiga($intJahr, $objLiga, \PageModel $objTargetPage = null)
    {
        global $objPage;
        $strFrontendUrl = $objTargetPage == null ? $this->generateFrontendUrl($objPage->row()) : $this->generateFrontendUrl($objTargetPage->row());
        $strLabel = LigaModel::getTitel($objLiga);

        if ($GLOBALS['TL_CONFIG']['useAutoItem']) {
            $arrParts = array($intJahr, strtolower($objLiga->bereich), strtolower($objLiga->liga), strtolower($objLiga->turnierart));
            if ($objLiga->nr != null) {
                $arrParts[] = $objLiga->nr;
            }
            return ampersand(sprintf('<a href="%1$s/%2$s">%3$s</a>', $strFrontendUrl, implode('-', $arrParts), $strLabel));
        } else {
            $arrParts = array('jahr' => $intJahr, 'bereich' => strtolower($objLiga->bereich), 'liga' => strtolower($objLiga->liga), 'turnierart' => strtolower($objLiga->turnierart));
            if ($objLiga->nr) {
                $arrParts['nr'] = $objLiga->nr;
            }
            $strQueryString = "";
            foreach ($arrParts as $key => $value) {
                if ($strQueryString != "") {
                    $strQueryString .= "&";
                }
                $strQueryString .= $key . "=" . $value;
            }
            return ampersand(sprintf('<a href="%1$s?%2$s">%3$s</a>', $strFrontendUrl, $strQueryString, $strLabel));
        }
    }

    protected function renderLinkTurnier($objTurnier, \PageModel $objTargetPage = null)
    {
        global $objPage;
        $strFrontendUrl = $objTargetPage == null ? $this->generateFrontendUrl($objPage->row()) : $this->generateFrontendUrl($objTargetPage->row());
        $strLabel = $objTurnier->titel;

        if ($GLOBALS['TL_CONFIG']['useAutoItem']) {
            $arrParts = array('turnier', $objTurnier->id);
            return ampersand(sprintf('<a href="%1$s/%2$s">%3$s</a>', $strFrontendUrl, implode('-', $arrParts), $strLabel));
        } else {
            $arrParts = array('turnier' => $objTurnier->id);
            $strQueryString = "";
            foreach ($arrParts as $key => $value) {
                if ($strQueryString != "") {
                    $strQueryString .= "&";
                }
                $strQueryString .= $key . "=" . $value;
            }
            return ampersand(sprintf('<a href="%1$s?%2$s">%3$s</a>', $strFrontendUrl, $strQueryString, $strLabel));
        }
    }
}
