<?php

namespace Tanzsport;

/**
 * Class SaisonModel
 * @package Tanzsport
 *
 * @property int $jahr Jahr
 */
class SaisonModel extends \Model
{

    protected static $strTable = "tl_td_erg_saison";

    public function __get($key)
    {
        switch ($key) {
            default:
                return parent::__get($key);
        }
    }

    public function __isset($key)
    {
        switch ($key) {
            default:
                return parent::__isset($key);
        }
    }

    /**
     * @return SaisonModel|null
     */
    public static function findLatestPublished()
    {
        return self::findOneBy('published', 1, ['order' => 'jahr DESC']);
    }

    public function getSaisonTitel($strTurnierart)
    {
        if ($strTurnierart == Ergebnisarchiv::TURNIERART_JMD) {
            return $this->jahr;
        } else {
            $intErstesJahr = $this->jahr - 1;
            return $intErstesJahr . "/" . $this->jahr;
        }
    }
}
