<?php

namespace Tanzsport;

class LigaTurnierModel extends \Model
{

    const TABLE = "tl_td_erg_liga_turnier";

    protected static $strTable = self::TABLE;

    public static function findPublishedByLigaOrderByDatum($intLigaId)
    {
        if (!$intLigaId) {
            throw new \InvalidArgumentException("Liga-ID erforderlich!");
        }
        $t = self::getTable();
        return static::findBy(array("$t.pid = ?", "$t.turnier_published = ?"), array($intLigaId, 1), array('order' => "$t.datum"));
    }

    public function __get($key)
    {
        switch ($key) {
            case 'datumAsObject':
                $dt = \DateTime::createFromFormat('U', $this->datum);
                if (!$dt) {
                    $dt = \DateTime::createFromFormat('U', 0);
                }
                return $dt->setTimezone(new \DateTimeZone('Europe/Berlin'));
            case 'hasAnfahrt':
                return $this->hasAnfahrt();
            case 'hasKarten':
                return $this->hasKarten();
            case 'hasTurnierstaette':
                return $this->hasTurnierstaette();
            case 'hasVorverkauf':
                return $this->hasVorverkauf();
            case 'hasZeiten':
                return $this->hasZeiten();
            case 'karten':
                return deserialize(parent::__get('karten'));
            case 'liga':
                return $this->getRelated('pid');
            case 'zeiten_beginn':
                return deserialize(parent::__get('zeiten_beginn'));
            default:
                return parent::__get($key);
        }
    }

    public function __isset($key)
    {
        switch ($key) {
            case 'datumAsObject':
                return isset($this->datum);
            case 'hasAnfahrt':
                return true;
            case 'hasKarten':
                return true;
            case 'hasTurnierstaette':
                return true;
            case 'hasVorverkauf':
                return true;
            case 'hasZeiten':
                return true;
            case 'karten':
                return parent::__isset('karten');
            case 'liga':
                return $this->getRelated('pid') != null;
            case 'zeiten_beginn':
                return parent::__isset('zeiten_beginn');
            default:
                return parent::__isset($key);
        }
    }

    public function __set($key, $value)
    {
        switch ($key) {
            case 'liga':
                parent::__set('pid', $value->id);
                break;
            default:
                parent::__set($key, $value);
        }
    }

    public function asArray()
    {
        $thisAsArray = $this->row();
        foreach (['zeiten_beginn', 'karten'] as $property) {
            $thisAsArray[$property] = deserialize($thisAsArray[$property], true);
        }
        $thisAsArray['datumText'] = $this->datumAsObject->format('d.m.Y');
        return $thisAsArray;
    }

    private function hasAnfahrt()
    {
        return $this->anfahrt_text || $this->anfahrt_url;
    }

    private function hasTurnierstaette()
    {
        return $this->tst_halle || $this->tst_telefon || $this->tst_adresse;
    }

    private function hasKarten()
    {
        return !empty($this->karten);
    }

    private function hasVorverkauf()
    {
        return $this->vvk_text || $this->vvk_anschrift || $this->vvk_telefon || $this->vvk_fax || $this->vvk_email_adresse || $this->vvk_online_url || $this->vvk_bemerkungen;
    }

    private function hasZeiten()
    {
        return !empty($this->zeiten_beginn) || $this->zeiten_einlass;
    }
}
