<?php

$GLOBALS['TL_DCA']['tl_td_erg_turnier_mannschaft'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'ptable' => 'tl_td_erg_turnier',
        'enableVersioning' => true,
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'pid' => 'index',
            )
        ),
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 4,
            'flag' => 12,
            'fields' => array('startnr'),
            'headerFields' => array('bereich', 'datum', 'ort', 'titel', 'pid'),
            'header_callback' => array('tl_td_erg_turnier_mannschaft', 'zeigeTurnier'),
            'panelLayout' => 'sort,filter;search,limit',
            'child_record_callback' => array('tl_td_erg_turnier_mannschaft', 'listeMannschaften'),
            'child_record_class' => 'no_padding',
            'disableGrouping' => true,
        ),
        'label' => array
        (
            'fields' => array('startnr', 'verein_name'),
            'format' => '%1$s) %2$s - '
        ),
        'global_operations' => array
        (/*
			'all' => array
			(
				'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
				'href' => 'act=select',
				'class' => 'header_edit_all',
				'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"'
			)
			*/
        ),
        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.gif'
            ),
            'cut' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_news']['cut'],
                'href' => 'act=paste&amp;mode=cut',
                'icon' => 'cut.gif'
            ),
            /*
            'copy' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['copy'],
                'href' => 'act=copy',
                'icon' => 'copy.gif'
            ),
            */
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.gif',
                'attributes' => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"',
                'button_callback' => array('tl_td_erg_turnier_mannschaft', 'deleteIcon')
            ),
            'toggle' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['toggle'],
                'icon' => 'visible.gif',
                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
                'button_callback' => array('tl_td_erg_turnier_mannschaft', 'toggleIcon')
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['show'],
                'href' => 'act=show',
                'icon' => 'show.gif'
            )
        )
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array(''),
        'default' => '{turnier_legende},startnr;{verein_legende},verein_name,verein_url;{team_legende},team_name,team_url;{trainer_legende},trainer;{kapitaen_legende},kapitaen_name,kapitaen_email;{kontakt_legende},kontakt;{bemerkungen_legende:hide},bemerkungen;{aufstieg_legende},aufstieg;{ergebnis_legende},platz;{veroeffentlichung_legende},published'
    ),

    // Subpalettes
    'subpalettes' => array
    (
        '' => ''
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'pid' => array
        (
            'foreignKey' => 'tl_td_erg_liga.id',
            'sql' => "int(10) unsigned NOT NULL default '0'",
            'relation' => array('type' => 'belongsTo', 'load' => 'eager')
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'startnr' => array
        (
            'sql' => "tinyint(1) unsigned NOT NULL default '0'",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['startnr'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => true, 'rgxp' => 'digit', 'tl_class' => 'w50'),
            'unique' => true,
        ),
        'verein_name' => array
        (
            'sql' => "varchar(96) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['verein_name'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => true, 'maxlength' => 96, 'tl_class' => 'w50'),
        ),
        'verein_url' => array
        (
            'sql' => "varchar(255) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['verein_url'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('rgxp' => 'url', 'maxlength' => 255, 'tl_class' => 'w50'),
        ),
        'team_name' => array
        (
            'sql' => "varchar(96) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['team_name'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => true, 'maxlength' => 96, 'tl_class' => 'w50'),
        ),
        'team_url' => array
        (
            'sql' => "varchar(255) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['team_url'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('rgxp' => 'url', 'maxlength' => 255, 'tl_class' => 'w50'),
        ),
        'trainer' => array
        (
            'sql' => 'blob NULL',
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['trainer'],
            'exclude' => false,
            'inputType' => 'tdNameEmailWidget',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false),
            'save_callback' => array(array('\Tanzsport\NameEmailWidget', 'saveCallback')),
        ),
        'kapitaen_name' => array
        (
            'sql' => "varchar(96) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['kapitaen_name'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 96, 'tl_class' => 'w50'),
        ),
        'kapitaen_email' => array
        (
            'sql' => "varchar(255) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['kapitaen_email'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('rgxp' => 'email', 'maxlength' => 255, 'tl_class' => 'w50'),
        ),
        'kontakt' => array
        (
            'sql' => 'blob NULL',
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['kontakt'],
            'exclude' => false,
            'inputType' => 'tdNameEmailWidget',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false),
            'save_callback' => array(array('\Tanzsport\NameEmailWidget', 'saveCallback')),
        ),
        'bemerkungen' => array
        (
            'sql' => 'blob NULL',
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['bemerkungen'],
            'exclude' => false,
            'inputType' => 'textarea',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'rte' => 'tinyMCE', 'tl_class' => 'clr'),
        ),
        'aufstieg' => array(
            'sql' => 'char(3) NULL',
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['aufstieg'],
            'default' => '',
            'exclude' => false,
            'inputType' => 'select',
            'options_callback' => array('\Tanzsport\Ergebnisarchiv', 'getAufstiegskennzeichenTurnierMitLabel'),
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'includeBlankOption' => false, 'tl_class' => 'w50'),
            'reference' => &$GLOBALS['TL_LANG'][\Tanzsport\Ergebnisarchiv::LNG_KEY]
        ),
        'platz' => array(
            'sql' => "varchar(2) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['platz'],
            'exclude' => true,
            'inputType' => 'text',
            'search' => false,
            'sorting' => false,
            'eval' => array('rgxp' => 'digit', 'maxlength' => 2, 'tl_class' => 'w50'),
        ),
        'published' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_turnier_mannschaft']['published'],
            'exclude' => false,
            'filter' => true,
            'flag' => 1,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true),
            'sql' => "char(1) NOT NULL default ''"
        ),
    )
);

class tl_td_erg_turnier_mannschaft extends \Tanzsport\Ergebnisarchiv
{
    public function __construct()
    {
        parent::__construct();
        $this->import('BackendUser', 'User');
    }

    public function listeMannschaften($arrRow)
    {
        return '<div class="tl_content_left">' . sprintf('%02d', $arrRow['startnr']) . ') ' . $arrRow['verein_name'] . ' - ' . $arrRow['team_name'] . '</div>';
    }

    public function zeigeTurnier($arrFields)
    {
        $ret = array();
        foreach ($arrFields as $k => $v) {
            if ($k == 'pid') {
                $ret['Saison'] = $v;
            } else {
                $ret[$k] = $v;
            }
        }
        return $ret;
    }

    public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (strlen(Input::get('tid'))) {
            $this->toggleVisibility(Input::get('tid'), (Input::get('state') == 1));
            $this->redirect($this->getReferer());
        }

        $href .= '&amp;tid=' . $row['id'] . '&amp;state=' . ($row['published'] ? '' : 1);

        if (!$row['published']) {
            $icon = 'invisible.gif';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '"' . $attributes . '>' . Image::getHtml($icon, $label) . '</a> ';
    }

    public function toggleVisibility($intId, $blnVisible)
    {
        $objVersions = new Versions('tl_td_erg_turnier_mannschaft', $intId);
        $objVersions->initialize();

        // Trigger the save_callback
        if (is_array($GLOBALS['TL_DCA']['tl_td_erg_turnier_mannschaft']['fields']['published']['save_callback'])) {
            foreach ($GLOBALS['TL_DCA']['tl_td_erg_turnier_mannschaft']['fields']['published']['save_callback'] as $callback) {
                if (is_array($callback)) {
                    $this->import($callback[0]);
                    $blnVisible = $this->$callback[0]->$callback[1]($blnVisible, $this);
                } elseif (is_callable($callback)) {
                    $blnVisible = $callback($blnVisible, $this);
                }
            }
        }

        // Update the database
        $this->Database->prepare("UPDATE tl_td_erg_turnier_mannschaft SET tstamp=" . time() . ", published='" . ($blnVisible ? 1 : '') . "' WHERE id=?")
            ->execute($intId);

        $objVersions->create();
    }

    public function deleteIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (!$this->User->isAdmin) {
            return;
        }
        return '<a href="' . $this->addToUrl('&amp;act=delete&amp;id=' . $row['id']) . '" title="' . specialchars($title) . '"' . $attributes . '>' . Image::getHtml($icon, $label) . '</a> ';
    }
}
