<?php

$GLOBALS['TL_DCA']['tl_td_erg_saison'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'ctable' => array('tl_td_erg_info', 'tl_td_erg_liga', 'tl_td_erg_turnier'),
        'switchToEdit' => true,
        'enableVersioning' => true,
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
            )
        ),
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 1,
            'fields' => array('jahr'),
            'flag' => 12,
            'panelLayout' => 'sort,filter;search,limit',
            'disableGrouping' => true,
        ),
        'label' => array
        (
            'fields' => array('jahr'),
            'format' => 'Saison %s'
        ),
        'global_operations' => array
        (/*
			'all' => array
			(
				'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
				'href' => 'act=select',
				'class' => 'header_edit_all',
				'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"'
			)
			*/
        ),
        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_saison']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.gif'
            ),
            'info' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_saison']['info'],
                'href' => 'table=tl_td_erg_info',
                'icon' => 'bundles/contaoformationen/icons/saisoninfo.gif'
            ),
            'ligen' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_saison']['ligen'],
                'href' => 'table=tl_td_erg_liga',
                'icon' => 'bundles/contaoformationen/icons/ligen.gif'
            ),
            'freieturniere' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_saison']['freieturniere'],
                'href' => 'table=tl_td_erg_turnier',
                'icon' => 'bundles/contaoformationen/icons/turniere.gif'
            ),
            /*
            'copy' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_saison']['copy'],
                'href' => 'act=copy',
                'icon' => 'copy.gif'
            ),
            */
            /*
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_saison']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.gif',
                'attributes' => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"'
            ),
            */
            'toggle' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_saison']['toggle'],
                'icon' => 'visible.gif',
                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
                'button_callback' => array('tl_td_erg_saison', 'toggleIcon')
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_saison']['show'],
                'href' => 'act=show',
                'icon' => 'show.gif'
            )
        )
    ),

    // Edit
    'edit' => array
    (
        'buttons_callback' => array
        ()
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array(''),
        'default' => '{saison_legende},jahr,published'
    ),

    // Subpalettes
    'subpalettes' => array
    (
        '' => ''
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'",
        ),
        'jahr' => array
        (
            'sql' => "smallint(2) unsigned NOT NULL default '0'",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_saison']['jahr'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => true, 'unique' => true, 'rgxp' => 'digit', 'tl_class' => 'w50'),
        ),
        'published' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_saison']['published'],
            'exclude' => false,
            'filter' => true,
            'flag' => 1,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true),
            'sql' => "char(1) NOT NULL default ''"
        ),
    )
);

class tl_td_erg_saison extends \Tanzsport\Ergebnisarchiv
{
    public function __construct()
    {
        parent::__construct();
    }

    public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (strlen(Input::get('tid'))) {
            $this->toggleVisibility(Input::get('tid'), (Input::get('state') == 1));
            $this->redirect($this->getReferer());
        }

        $href .= '&amp;tid=' . $row['id'] . '&amp;state=' . ($row['published'] ? '' : 1);

        if (!$row['published']) {
            $icon = 'invisible.gif';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '"' . $attributes . '>' . Image::getHtml($icon, $label) . '</a> ';
    }

    public function toggleVisibility($intId, $blnVisible)
    {
        $objVersions = new Versions('tl_td_erg_saison', $intId);
        $objVersions->initialize();

        // Trigger the save_callback
        if (is_array($GLOBALS['TL_DCA']['tl_td_erg_saison']['fields']['published']['save_callback'])) {
            foreach ($GLOBALS['TL_DCA']['tl_td_erg_saison']['fields']['published']['save_callback'] as $callback) {
                if (is_array($callback)) {
                    $this->import($callback[0]);
                    $blnVisible = $this->$callback[0]->$callback[1]($blnVisible, $this);
                } elseif (is_callable($callback)) {
                    $blnVisible = $callback($blnVisible, $this);
                }
            }
        }

        // Update the database
        $this->Database->prepare("UPDATE tl_td_erg_saison SET tstamp=" . time() . ", published='" . ($blnVisible ? 1 : '') . "' WHERE id=?")
            ->execute($intId);

        $objVersions->create();
    }
}
