<?php

namespace Tanzsport;

/* ligabereiche */

use Contao\BackendUser;

define('BEREICH_F_BL', 'FBL');
define('BEREICH_F_N', 'FN');
define('BEREICH_F_W', 'FW');
define('BEREICH_F_S', 'FS');
define('BEREICH_F_NW', 'FNW');
define('BEREICH_F_SW', 'FSW');

define('ORDER_F_BL', 1);
define('ORDER_F_N', 11);
define('ORDER_F_NW', 12);
define('ORDER_F_W', 21);
define('ORDER_F_S', 31);
define('ORDER_F_SW', 41);

define('BEREICH_J_BL', 'JBL');
define('BEREICH_J_NO', 'JNO');
define('BEREICH_J_W', 'JW');
define('BEREICH_J_SO', 'JSO');
define('BEREICH_J_S', 'JS');

define('ORDER_J_BL', 1);
define('ORDER_J_NO', 11);
define('ORDER_J_W', 21);
define('ORDER_J_SO', 31);
define('ORDER_J_S', 41);

/* ligen */

define('LIGA_1BL', '1BL');
define('LIGA_2BL', '2BL');
define('LIGA_RL', 'RL');
define('LIGA_OL', 'OL');
define('LIGA_VL', 'VL');
define('LIGA_LL', 'LL');
define('LIGA_JVL', 'JVL');
define('LIGA_JLL', 'JLL');
define('LIGA_KL', 'KL');
define('LIGA_KVL', 'KVL');
define('LIGA_KLL', 'KLL');

define('ORDER_1BL', 1);
define('ORDER_2BL', 2);
define('ORDER_RL', 3);
define('ORDER_OL', 4);
define('ORDER_VL', 5);
define('ORDER_LL', 6);
define('ORDER_JVL', 7);
define('ORDER_JLL', 8);
define('ORDER_KL', 9);
define('ORDER_KVL', 10);
define('ORDER_KLL', 11);

/* turnierarten */

define('TURNIERART_ST', 'STD');
define('TURNIERART_LAT', 'LAT');
define('TURNIERART_JMD', 'JMD');

define('ORDER_ST', 1);
define('ORDER_LAT', 2);
define('ORDER_JMD', 3);

/* runden und stati */

define('RUNDE_GF', 'GF');
define('RUNDE_KF', 'KF');
define('RUNDE_ZR', 'ZR');
define('RUNDE_VR', 'VR');

define('DISQUALIFIZIERT', 'D');
define('NICHT_ANGETRETEN', 'NA');

/* landesverbaende */

define('LTV_BAYERN', 'LTVB');
define('LTV_BERLIN', 'LTV Berlin');
define('LTV_BRANDENBURG', 'LTV Br');
define('LTV_BREMEN', 'LTV Bremen');
define('LTV_SACHSEN', 'TVS');
define('LTV_SACHSEN_ANHALT', 'TVSA');
define('LTV_HAMBURG', 'HATV');
define('LTV_HESSEN', 'HTV');
define('LTV_NIEDERSACHSEN', 'NTV');
define('LTV_SAARLAND', 'SLT');
define('LTV_BADEN_WUERTTEMBERG', 'TBW');
define('LTV_MECKLENBURG_VORPOMMERN', 'TMV');
define('LTV_NORDRHEIN_WESTFALEN', 'TNW');
define('LTV_RHEINLAND_PFALZ', 'TRP');
define('LTV_SCHLESWIG_HOLSTEIN', 'TSH');
define('LTV_THUERINGEN', 'TTSV');
define('LTV_AUSLAND', 'Ausland');

/* auf- und abstiegskennzeichen */

define('KZ_NONE', '');
define('KZ_DAU', 'DAU');
define('KZ_DAB', 'DAB');
define('KZ_TAU', 'TAU');
define('KZ_RHL', 'RHL');
define('KZ_RNL', 'RNL');
define('KZ_AUF', 'AUF');
define('KZ_ABS', 'ABS');

class Ergebnisarchiv extends \Backend
{

    const LNG_KEY = 'tl_td_erg';

    /* turnierarten */
    const TURNIERART_ST = TURNIERART_ST;
    const TURNIERART_LAT = TURNIERART_LAT;
    const TURNIERART_JMD = TURNIERART_JMD;

    /* ligabereiche */
    const BEREICH_F_BL = BEREICH_F_BL;
    const BEREICH_F_N = BEREICH_F_N;
    const BEREICH_F_W = BEREICH_F_W;
    const BEREICH_F_S = BEREICH_F_S;
    const BEREICH_F_NW = BEREICH_F_NW;
    const BEREICH_F_SW = BEREICH_F_SW;

    const ORDER_F_BL = ORDER_F_BL;
    const ORDER_F_N = ORDER_F_N;
    const ORDER_F_NW = ORDER_F_NW;
    const ORDER_F_W = ORDER_F_W;
    const ORDER_F_S = ORDER_F_S;
    const ORDER_F_SW = ORDER_F_SW;

    const BEREICH_J_BL = BEREICH_J_BL;
    const BEREICH_J_NO = BEREICH_J_NO;
    const BEREICH_J_W = BEREICH_J_W;
    const BEREICH_J_SO = BEREICH_J_SO;
    const BEREICH_J_S = BEREICH_J_S;

    const ORDER_J_BL = ORDER_J_BL;
    const ORDER_J_NO = ORDER_J_NO;
    const ORDER_J_W = ORDER_J_W;
    const ORDER_J_SO = ORDER_J_SO;
    const ORDER_J_S = ORDER_J_SO;

    /* ligen */
    const LIGA_1BL = LIGA_1BL;
    const LIGA_2BL = LIGA_2BL;
    const LIGA_RL = LIGA_RL;
    const LIGA_OL = LIGA_OL;
    const LIGA_VL = LIGA_VL;
    const LIGA_LL = LIGA_LL;
    const LIGA_JVL = LIGA_JVL;
    const LIGA_JLL = LIGA_JLL;
    const LIGA_KL = LIGA_KL;
    const LIGA_KVL = LIGA_KVL;
    const LIGA_KLL = LIGA_KLL;

    const ORDER_1BL = ORDER_1BL;
    const ORDER_2BL = ORDER_2BL;
    const ORDER_RL = ORDER_RL;
    const ORDER_OL = ORDER_OL;
    const ORDER_VL = ORDER_VL;
    const ORDER_LL = ORDER_LL;
    const ORDER_JVL = ORDER_JVL;
    const ORDER_JLL = ORDER_JLL;
    const ORDER_KL = ORDER_KL;
    const ORDER_KVL = ORDER_KVL;
    const ORDER_KLL = ORDER_KLL;

    /* runden und stati */
    const RUNDE_GF = RUNDE_GF;
    const RUNDE_KF = RUNDE_KF;
    const RUNDE_ZR = RUNDE_ZR;
    const RUNDE_VR = RUNDE_VR;

    const DISQUALIFIZIERT = DISQUALIFIZIERT;
    const NICHT_ANGETRETEN = NICHT_ANGETRETEN;

    /* landesverbaende */
    const LTV_BAYERN = LTV_BAYERN;
    const LTV_BERLIN = LTV_BERLIN;
    const LTV_BRANDENBURG = LTV_BRANDENBURG;
    const LTV_BREMEN = LTV_BREMEN;
    const LTV_SACHSEN = LTV_SACHSEN;
    const LTV_SACHSEN_ANHALT = LTV_SACHSEN_ANHALT;
    const LTV_HAMBURG = LTV_HAMBURG;
    const LTV_HESSEN = LTV_HESSEN;
    const LTV_NIEDERSACHSEN = LTV_NIEDERSACHSEN;
    const LTV_SAARLAND = LTV_SAARLAND;
    const LTV_BADEN_WUERTTEMBERG = LTV_BADEN_WUERTTEMBERG;
    const LTV_MECKLENBURG_VORPOMMERN = LTV_MECKLENBURG_VORPOMMERN;
    const LTV_NORDRHEIN_WESTFALEN = LTV_NORDRHEIN_WESTFALEN;
    const LTV_RHEINLAND_PFALZ = LTV_RHEINLAND_PFALZ;
    const LTV_SCHLESWIG_HOLSTEIN = LTV_SCHLESWIG_HOLSTEIN;
    const LTV_THUERINGEN = LTV_THUERINGEN;
    const LTV_AUSLAND = LTV_AUSLAND;

    /* auf- und abstiegskennzeichen */
    const KZ_NONE = KZ_NONE;
    const KZ_DAU = KZ_DAU;
    const KZ_DAB = KZ_DAB;
    const KZ_TAU = KZ_TAU;
    const KZ_RHL = KZ_RHL;
    const KZ_RNL = KZ_RNL;
    const KZ_AUF = KZ_AUF;
    const KZ_ABS = KZ_ABS;

    /**
     * @var array
     */
    private $arrLigabereiche;

    /**
     * @var array
     */
    private $arrLigabereicheStLat;

    /**
     * @var array
     */
    private $arrLigabereicheJmd;

    /**
     * @var array
     */
    private $arrLigabereicheMitLabelInternal;

    /**
     * @var array
     */
    private $arrBundesligenStLat;

    /**
     * @var array
     */
    private $arrBundesligenStLatMitLabel;

    /**
     * @var array
     */
    private $arrUntereLigenStLat;

    /**
     * @var array
     */
    private $arrUntereLigenStLatMitLabel;

    /**
     * @var array
     */
    private $arrTurnierartenStLat;

    /**
     * @var array
     */
    private $arrTurnierartenStLatMitLabel;

    /**
     * @var array
     */
    private $arrBundesligenJmd;

    /**
     * @var array
     */
    private $arrBundesligenJmdMitLabel;

    /**
     * @var array
     */
    private $arrUntereLigenJmd;

    /**
     * @var array
     */
    private $arrUntereLigenJmdMitLabel;

    /**
     * @var array
     */
    private $arrTurnierartenJmd;

    /**
     * @var array
     */
    private $arrTurnierartenJmdMitLabel;

    /**
     * @var array
     */
    private $arrTurnierarten;

    /**
     * @var array
     */
    private $arrTurnierartenMitLabel;

    /**
     * @var array
     */
    private $arrRunden;

    /**
     * @var array
     */
    private $arrRundenMitLabel;

    /**
     * @var array
     */
    private $arrLandesverbaende;

    /**
     * @var array
     */
    private $arrLandesverbaendeMitLabel;

    /**
     * @var array
     */
    private $arrAufstiegskennzeichen;

    /**
     * @var array
     */
    private $arrAufstiegskennzeichenMitLabel;

    /**
     * @var array
     */
    private $arrAufstiegskennzeichenTurnierMitLabel;

    public function __construct()
    {
        parent::__construct();

        $this->arrLigabereiche = array(
            BEREICH_F_BL, BEREICH_F_N, BEREICH_F_NW, BEREICH_F_S, BEREICH_F_W, BEREICH_F_SW, BEREICH_J_BL, BEREICH_J_NO, BEREICH_J_S, BEREICH_J_SO, BEREICH_J_W
        );

        $this->arrLigabereicheStLat = array(
            BEREICH_F_BL, BEREICH_F_N, BEREICH_F_NW, BEREICH_F_S, BEREICH_F_W, BEREICH_F_SW
        );

        $this->arrLigabereicheJmd = array(
            BEREICH_J_BL, BEREICH_J_NO, BEREICH_J_S, BEREICH_J_SO, BEREICH_J_W
        );

        $this->arrBundesligenStLat = array(
            LIGA_1BL, LIGA_2BL
        );

        $this->arrUntereLigenStLat = array(
            LIGA_RL, LIGA_OL, LIGA_LL
        );

        $this->arrTurnierartenStLat = array(
            TURNIERART_ST, TURNIERART_LAT
        );

        $this->arrBundesligenJmd = array(
            LIGA_1BL, LIGA_2BL
        );

        $this->arrUntereLigenJmd = array(
            LIGA_RL, LIGA_OL, LIGA_VL, LIGA_LL, LIGA_JVL, LIGA_JLL, LIGA_KVL, LIGA_KLL, LIGA_KL
        );

        $this->arrTurnierartenJmd = array(
            TURNIERART_JMD
        );

        $this->arrTurnierarten = array(
            TURNIERART_ST, TURNIERART_LAT, TURNIERART_JMD
        );

        $this->arrRunden = array(
            RUNDE_GF, RUNDE_KF, RUNDE_ZR, RUNDE_VR, NICHT_ANGETRETEN
        );

        $this->arrLandesverbaende = array(
            LTV_BADEN_WUERTTEMBERG, LTV_BAYERN, LTV_BERLIN, LTV_BRANDENBURG, LTV_BREMEN, LTV_HAMBURG, LTV_HESSEN,
            LTV_MECKLENBURG_VORPOMMERN, LTV_NIEDERSACHSEN, LTV_NORDRHEIN_WESTFALEN, LTV_RHEINLAND_PFALZ,
            LTV_SAARLAND, LTV_SACHSEN, LTV_SACHSEN_ANHALT, LTV_SCHLESWIG_HOLSTEIN, LTV_THUERINGEN, LTV_AUSLAND
        );
        asort($this->arrLandesverbaende);

        $this->arrAufstiegskennzeichen = array(
            KZ_NONE, KZ_DAU, KZ_DAB, KZ_TAU, KZ_RHL, KZ_RNL
        );

        $this->arrAufstiegskennzeichenTurnier = array(
            KZ_NONE, KZ_AUF, KZ_ABS
        );
    }

    public function getLandesverbaende()
    {
        return $this->arrLandesverbaende;
    }

    public function getLandesverbaendeMitLabel()
    {
        if ($this->arrLandesverbaendeMitLabel == null) {
            \System::loadLanguageFile(self::LNG_KEY);
            $this->arrLandesverbaendeMitLabel = array();
            foreach ($this->arrLandesverbaende as $l) {
                $this->arrLandesverbaendeMitLabel[$l] = &$GLOBALS['TL_LANG'][self::LNG_KEY][$l];
            }
            asort($this->arrLandesverbaendeMitLabel);
        }
        return $this->arrLandesverbaendeMitLabel;
    }

    /**
     * Gibt alle Ligabereiche und ihre Labels zur&uuml;ck.
     *
     * @return array
     */
    public function getLigabereicheMitLabelInternal()
    {
        if ($this->arrLigabereicheMitLabelInternal == null) {
            \System::loadLanguageFile(self::LNG_KEY);
            foreach ($this->arrLigabereiche as $b) {
                $this->arrLigabereicheMitLabelInternal[$b] = &$GLOBALS['TL_LANG'][self::LNG_KEY]['internal'][$b];
            }
        }
        return $this->arrLigabereicheMitLabelInternal;
    }

    /**
     * Gibt alle Ligabereiche mit Label zur&uuml;ck, auf die der aktuelle Benutzer Zugriff hat.
     *
     * @return array
     */
    public function getVerfuegbareLigabereicheMitLabelInternal()
    {
        $bereiche = $this->getLigabereicheMitLabelInternal();
        if ($this->getUser()->admin) {
            return $bereiche;
        } else {
            $verfuegbarerBereiche = $this->getVerfuegbareLigabereicheAusBenutzerGruppen();
            foreach ($bereiche as $key => $label) {
                if (!in_array($key, $verfuegbarerBereiche)) {
                    unset($bereiche[$key]);
                }
            }
            return $bereiche;
        }
    }

    /**
     * Gibt alle Ligen in Abh&auml;ngigkeit vom aktuellen Ligabereich mit Labels zur&uuml;ck.
     *
     * @param DC_Table $dc
     * @return array
     */
    public function getLigenMitLabel(\DC_Table $dc)
    {
        if ($dc->activeRecord->bereich) {
            if (in_array($dc->activeRecord->bereich, $this->arrLigabereicheStLat)) {
                if ($dc->activeRecord->bereich == BEREICH_F_BL) {
                    return $this->getBundesligenStLatMitLabel();
                } else {
                    return $this->getUntereLigenStLatMitLabel();
                }
            } else if (in_array($dc->activeRecord->bereich, $this->arrLigabereicheJmd)) {
                if ($dc->activeRecord->bereich == BEREICH_J_BL) {
                    return $this->getBundesligenJmdMitLabel();
                } else {
                    return $this->getUntereLigenJmdMitLabel();
                }
            } else {
                return array();
            }
        } else {
            return array();
        }
    }

    /**
     * Gibt alle Bundesligen St/Lat mit Label zur&uuml;ck.
     *
     * @return array
     */
    protected function getBundesligenStLatMitLabel()
    {
        \System::loadLanguageFile(self::LNG_KEY);
        if ($this->arrBundesligenStLatMitLabel == null) {
            foreach ($this->arrBundesligenStLat as $l) {
                $this->arrBundesligenStLatMitLabel[$l] = &$GLOBALS['TL_LANG'][self::LNG_KEY][$l];
            }
        }
        return $this->arrBundesligenStLatMitLabel;
    }

    /**
     * Gibt alle unteren Ligen St/Lat mit Label zur&uuml;ck.
     *
     * @return array
     */
    protected function getUntereLigenStLatMitLabel()
    {
        \System::loadLanguageFile(self::LNG_KEY);
        if ($this->arrUntereLigenStLatMitLabel == null) {
            foreach ($this->arrUntereLigenStLat as $l) {
                $this->arrUntereLigenStLatMitLabel[$l] = &$GLOBALS['TL_LANG'][self::LNG_KEY][$l];
            }
        }
        return $this->arrUntereLigenStLatMitLabel;
    }

    /**
     * Gibt alle Bundesligen JMD mit Label zur&uuml;ck.
     *
     * @return array
     */
    protected function getBundesligenJmdMitLabel()
    {
        \System::loadLanguageFile(self::LNG_KEY);
        if ($this->arrBundesligenJmdMitLabel == null) {
            foreach ($this->arrBundesligenJmd as $l) {
                $this->arrBundesligenJmdMitLabel[$l] = &$GLOBALS['TL_LANG'][self::LNG_KEY][$l];
            }
        }
        return $this->arrBundesligenJmdMitLabel;
    }

    /**
     * Gibt alle unteren Ligen JMD mit Label zur&uuml;ck.
     *
     * @return array
     */
    protected function getUntereLigenJmdMitLabel()
    {
        \System::loadLanguageFile(self::LNG_KEY);
        if ($this->arrUntereLigenJmdMitLabel == null) {
            foreach ($this->arrUntereLigenJmd as $l) {
                $this->arrUntereLigenJmdMitLabel[$l] = &$GLOBALS['TL_LANG'][self::LNG_KEY][$l];
            }
        }
        return $this->arrUntereLigenJmdMitLabel;
    }

    /**
     * Gibt alle Turnierarten St/Lat mit Label zur&uml;ck.
     *
     * @return array
     */
    public function getTurnierartenStLatMitLabel()
    {
        \System::loadLanguageFile(self::LNG_KEY);
        if ($this->arrTurnierartenStLatMitLabel == null) {
            foreach ($this->arrTurnierartenStLat as $ta) {
                $this->arrTurnierartenStLatMitLabel[$ta] = &$GLOBALS['TL_LANG'][self::LNG_KEY][$ta];
            }
        }
        return $this->arrTurnierartenStLatMitLabel;
    }

    /**
     * Gibt alle Turnierarten JMD mit Label zur&uuml;ck.
     *
     * @return array
     */
    public function getTurnierartenJmdMitLabel()
    {
        \System::loadLanguageFile(self::LNG_KEY);
        if ($this->arrTurnierartenJmdMitLabel == null) {
            foreach ($this->arrTurnierartenJmd as $ta) {
                $this->arrTurnierartenJmdMitLabel[$ta] = &$GLOBALS['TL_LANG'][self::LNG_KEY][$ta];
            }
        }
        return $this->arrTurnierartenJmdMitLabel;
    }

    /**
     * Gibt alle Turnierarten in Abh&auml;ngigkeit vom aktuellen Ligabereich mit Labels zur&uuml;ck.
     *
     * @param DC_Table $dc
     * @return array
     */
    public function getTurnierartenMitLabel(\DC_Table $dc)
    {
        if ($dc->activeRecord->bereich) {
            if (in_array($dc->activeRecord->bereich, $this->arrLigabereicheStLat)) {
                return $this->getTurnierartenStLatMitLabel();
            } else if (in_array($dc->activeRecord->bereich, $this->arrLigabereicheJmd)) {
                return $this->getTurnierartenJmdMitLabel();
            } else {
                return array();
            }
        } else {
            return array();
        }
    }

    /**
     * Gibt alle Turnieraten mit Label zur&uuml;ck.
     *
     * @return array
     */
    public function getAlleTurnierartenMitLabel()
    {
        return array_merge($this->getTurnierartenStLatMitLabel(), $this->getTurnierartenJmdMitLabel());
    }

    /**
     *  Gibt alle Runden und Stati mit Label zur&uuml;ck;
     *
     * @return array
     */
    public function getRundenUndStatiMitLabel()
    {
        \System::loadLanguageFile(self::LNG_KEY);
        if ($this->arrRundenMitLabel == null) {
            foreach ($this->arrRunden as $r) {
                $this->arrRundenMitLabel[$r] = &$GLOBALS['TL_LANG'][self::LNG_KEY][$r];
            }
        }
        return $this->arrRundenMitLabel;
    }

    public function getAufstiegskennzeichenMitLabel()
    {
        \System::loadLanguageFile(self::LNG_KEY);
        if ($this->arrAufstiegskennzeichenMitLabel == null) {
            foreach ($this->arrAufstiegskennzeichen as $k) {
                $this->arrAufstiegskennzeichenMitLabel[$k] = &$GLOBALS['TL_LANG'][self::LNG_KEY][$k];
            }
        }
        return $this->arrAufstiegskennzeichenMitLabel;
    }

    public function getAufstiegskennzeichenTurnierMitLabel()
    {
        \System::loadLanguageFile(self::LNG_KEY);
        if ($this->arrAufstiegskennzeichenTurnierMitLabel == null) {
            foreach ($this->arrAufstiegskennzeichenTurnier as $k) {
                $this->arrAufstiegskennzeichenTurnierMitLabel[$k] = &$GLOBALS['TL_LANG'][self::LNG_KEY][$k];
            }
        }
        return $this->arrAufstiegskennzeichenTurnierMitLabel;
    }

    /**
     * Gibt die Ligabereiche zur&uml;cl, auf die der Benutzer Zugriff hat. Admin-Benutzer erhalten automatisch Zugriff
     * auf alle Ligabereiche.
     *
     * @return array
     */
    protected function getVerfuegbareLigabereicheAusBenutzerGruppen()
    {
        $groupIds = implode(',', array_map('intval', $this->getUser()->groups));

        /**
         * @var $groups \Model\Collection
         */
        $groups = \UserGroupModel::findBy(array('td_erg_bereich IS NOT NULL', "id IN(" . $groupIds . ")"), null);

        $bereiche = array();
        if ($groups != null && $groups->count() > 0) {
            foreach ($groups->getIterator() as $group) {
                $bereiche[] = $group->td_erg_bereich;
            }
            return $bereiche;
        } else {
            return array();
        }
    }

    /**
     * @return \User
     */
    private function getUser()
    {
        return \BackendUser::getInstance();
    }

    public static function getSortIndexLiga($liga)
    {
        switch ($liga) {
            case LIGA_1BL:
                return ORDER_1BL;
            case LIGA_2BL:
                return ORDER_2BL;
            case LIGA_RL:
                return ORDER_RL;
            case LIGA_OL:
                return ORDER_OL;
            case LIGA_VL:
                return ORDER_VL;
            case LIGA_LL:
                return ORDER_LL;
            case LIGA_JVL:
                return ORDER_JVL;
            case LIGA_JLL:
                return ORDER_JLL;
            case LIGA_KL:
                return ORDER_KL;
            case LIGA_KVL:
                return ORDER_KVL;
            case LIGA_KLL:
                return ORDER_KLL;
            default:
                return 0;
        }
    }

    public static function getSortIndexTurnierart($turnierart)
    {
        switch ($turnierart) {
            case TURNIERART_ST:
                return ORDER_ST;
            case TURNIERART_LAT:
                return ORDER_LAT;
            case TURNIERART_JMD:
                return ORDER_JMD;
            default:
                return 0;
        }
    }

    public static function getSortIndexBereich($bereich)
    {
        switch ($bereich) {
            case BEREICH_F_BL:
                return ORDER_F_BL;
            case BEREICH_F_N:
                return ORDER_F_N;
            case BEREICH_F_W:
                return ORDER_F_W;
            case BEREICH_F_S:
                return ORDER_F_S;
            case BEREICH_F_NW:
                return ORDER_F_NW;
            case BEREICH_F_SW:
                return ORDER_F_SW;
            case BEREICH_J_BL:
                return ORDER_J_BL;
            case BEREICH_J_NO:
                return ORDER_J_NO;
            case BEREICH_J_W:
                return ORDER_J_W;
            case BEREICH_J_SO:
                return ORDER_J_SO;
            case BEREICH_J_S:
                return ORDER_J_S;
            default:
                return 0;
        }
    }

    public static function getLigabereicheByUser()
    {
        if (TL_MODE !== 'BE') {
            return [];
        }
        /**
         * @var $user BackendUser
         */
        $user = BackendUser::getInstance();

        if (!$user->admin) {
            $userGroupIds = implode(',', array_map('intval', $user->groups));

            $userGroups = null;
            if (count($user->groups) > 0) {
                /**
                 * @var $userGroups \Contao\Model\Collection
                 */
                $userGroups = \UserGroupModel::findBy(array('td_erg_bereich IS NOT NULL', "id IN(" . $userGroupIds . ")"), null);
            }

            $bereiche = array();
            if ($userGroups != null && $userGroups->count() > 0) {
                foreach ($userGroups->getIterator() as $group) {
                    $bereiche[] = $group->td_erg_bereich;
                }
            }

            if (!empty($bereiche)) {
                $strOr = '';
                $first = true;
                foreach ($bereiche as $b) {
                    if (!$first) {
                        $strOr .= ' OR ';
                    }
                    $strOr .= 'bereich = \'' . $b . '\'';
                    $first = false;
                }
                return array(array('((' . $strOr . ') AND 1 = ?)', 1));
            } else {
                return array(array('bereich = ?', null));
            }
        }
    }

}
