<?php

namespace Tanzsport\ContaoFormationenBundle\Controller\FrontendModule;

use Contao\Config;
use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Framework\ContaoFramework;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\Input;
use Contao\ModuleModel;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule("td_formationen_esv",
 *     category="td",
 *     template="mod_esv_formationen",
 *     renderer="forward"
 * )
 */
class EsvFormationenFrontendModuleController extends AbstractFrontendModuleController
{

    public static $sparten = [
            'stdlat' => 'Standard/Latein',
            'jmc' => 'JMC'
    ];

    public static $views = [
            'bundesligen' => 'Bundesligen',
            'ligabereiche' => 'Ligabereiche',
            'archiv' => 'Archiv'
    ];

    public static $envs = [
            'prod' => 'Produktion',
            'qa' => 'QA'
    ];

    private static $baseUri = [
            'prod' => 'https://ev.tanzsport-portal.de',
            'qa' => 'https://ev-qa.tanzsport-portal.de'
    ];

    private ContaoFramework $framework;

    public function __construct(
            ContaoFramework $framework
    )
    {
        $this->framework = $framework;
        $this->framework->initialize(true);
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        if ($this->isUseAutoItem()) {
            $input = $this->framework->getAdapter(Input::class);
            $this->framework->getAdapter(Input::class)->get('auto_item');
        } else {
            throw new \RuntimeException("Only auto_item mode supported");
        }

        $GLOBALS['TL_HEAD'][] = Template::generateScriptTag('bundles/contaoformationen/formationen/formationen.js', false, null, null, 'anonymous');

        $template->sparte = $model->td_formationen_sparte;
        $template->view = $model->td_formationen_view;
        $template->baseUri = $model->td_formationen_env ? (self::$baseUri[$model->td_formationen_env] ?? self::$baseUri['prod']) : self::$baseUri['prod'];
        return $template->getResponse();
    }

    private function isUseAutoItem(): bool
    {
        return $this->framework->getAdapter(Config::class)->get('useAutoItem');
    }
}
