var DatenMeldenApp = angular.module('DatenMeldenApp', ['ngWig']);
DatenMeldenApp.config(function ($interpolateProvider) {
	$interpolateProvider.startSymbol('{!');
	$interpolateProvider.endSymbol('!}');
});

DatenMeldenApp.controller('TurnierdatenController', ['$scope', '$http', function ($scope, $http) {
	$scope.liga = null;
	$scope.ligen = [];
	$scope.turnier = null;
	$scope.turniere = [];
	$scope.absender = {name: null, email: null}
	$scope.routes = {
		ligen: '',
		turniere: '',
		melden: '',
	};

	$scope.init = function(ligen, turniere, melden) {
		$scope.routes = {
			ligen,
			turniere,
			melden
		};
		$http({method: 'GET', url: $scope.routes.ligen}).then(function (response) {
			$scope.ligen = response.data;
		});
	}

	$scope.addBeginn = function () {
		if ($scope.turnier != null) {
			$scope.turnier.zeiten_beginn.push({uhrzeit: null, text: null});
		}
		return false;
	}
	$scope.removeBeginn = function (index) {
		if($scope.turnier != null) {
			$scope.turnier.zeiten_beginn.splice(index, 1);
		}
	}
	$scope.addKategorie = function () {
		if ($scope.turnier != null) {
			$scope.turnier.karten.push({preis: null, text: null});
		}
		return false;
	}
	$scope.removeKategorie = function (index) {
		if($scope.turnier != null) {
			$scope.turnier.karten.splice(index, 1);
		}
	}

	$scope.submit = function($event) {
		if($scope.form.$valid) {
			$event.currentTarget.disabled = true;
			$event.currentTarget.innerText = 'Daten werden übertragen…';
			$http({
				method: 'POST',
				url: $scope.routes.melden,
				data: {
					liga: $scope.liga,
					turnier: $scope.turnier,
					absender: $scope.absender
				}
			}).then(
				function (response) {
					swal({
						title: 'Turnierdaten übermittelt',
						text: 'Die gemeldeten Turnierdaten wurden erfolgreich übermittelt und werden nun geprüft.',
						timer: 5000,
						type: 'success',
						showConfirmButton: true
					});
					$scope.turnier = null;
					$scope.form.$setPristine();
					$scope.form.$setUntouched();
					$event.currentTarget.disabled = false;
					$event.currentTarget.innerText = 'absenden';
				},
				function (response) {
					swal({
						title: 'Übermittlungsfehler',
						text: 'Die Daten konnten nicht übermittelt werden. Bitte versuchen Sie es erneut.',
						type: 'error',
						showConfirmButton: true
					});
					$event.currentTarget.disabled = false;
					$event.currentTarget.innerText = 'absenden';
				}
			);
		}
	}

	$scope.$watch('liga', function (newValue, oldValue, scope) {
		if (newValue && newValue != oldValue) {
			if (newValue.isTurnier) {
				scope.turnier = newValue;
				scope.turniere = [newValue];
			} else {
				scope.turnier = null;
				scope.turniere = [];
				$http({
					method: 'GET',
					url: $scope.routes.turniere + '?l=' + $scope.liga.id
				}).then(function (response) {
					scope.turniere = response.data;
				});
			}
		}
	});

	$scope.$watch('turnier', function (newValue, oldValue, scope) {
		if (newValue && newValue != oldValue) {
			$scope.form.$setPristine();
			$scope.form.$setUntouched();
		}
	});
}]);
