var DatenMeldenApp = angular.module('DatenMeldenApp', []);
DatenMeldenApp.config(function ($interpolateProvider) {
	$interpolateProvider.startSymbol('{!');
	$interpolateProvider.endSymbol('!}');
});

DatenMeldenApp.controller('ErgebnisController', ['$scope', '$http', function ($scope, $http) {
	$scope.liga = null;
	$scope.ligen = [];
	$scope.turnier = null;
	$scope.turniere = [];
	$scope.mannschaften = [];
	$scope.absender = {name: null, email: null}
	$scope.anzahlenWr = [3, 5, 7, 9, 11];
	$scope.anzahlWr = 5;
	$scope.plaetze = [];
	$scope.ergebnis = [];
	$scope.wertungsrichter = [];
	$scope.landesverbaende = [];
	$scope.routes = {
		ligen: '',
		stammdatenLiga: '',
		stammdatenTurnier: '',
		melden: ''
	}

	function initData() {
		$scope.plaetze = [];
		$scope.ergebnis = [];

		for (var i = 0; i < $scope.mannschaften.length; i++) {
			var e = {
				pz: i + 1,
				mannschaft: null,
				runde: 'GF',
				wertungen: [],
				disqualifiziert: false
			};
			for(var j = 0; j < $scope.anzahlWr; j++) {
				e.wertungen.push({wertung: null});
			}
			$scope.ergebnis.push(e);
			$scope.plaetze.push(i + 1);
			if (i != $scope.mannschaften.length - 1) {
				$scope.plaetze.push(i + 1.5);
			}
		}
		$scope.plaetze.push($scope.mannschaften.length + 1);
		$scope.plaetze.push($scope.mannschaften.length + 2);
		$scope.plaetze.push($scope.mannschaften.length + 3);

		$scope.wertungsrichter = [];
		for(var i = 0; i < $scope.anzahlWr; i++) {
			$scope.wertungsrichter.push({
				kuerzel: String.fromCharCode(65 + i),
				name: null,
				verein: null,
				ltv: null
			});
		}
	}

	$scope.init = function (ligen, stammdatenLiga, stammdatenTurnier, melden) {
		$scope.routes = {
			ligen,
			stammdatenLiga,
			stammdatenTurnier,
			melden
		}
		$http({
			method: 'GET',
			url: $scope.routes.ligen
		}).then(function (response) {
			$scope.ligen = response.data;
		});
	}

	$scope.rundeChanged = function (zeile) {
		var runde = $scope.ergebnis[zeile].runde;
		if (runde == 'GF' || runde == 'KF' || runde == 'ZR' || runde == 'VR') {
			for (var i = zeile; i < $scope.ergebnis.length; i++) {
				$scope.ergebnis[i].runde = runde;
			}
		}
	}

	$scope.mannschaftChanged = function (zeile) {
		if ($scope.ergebnis[zeile].mannschaft != null && $scope.ergebnis[zeile].mannschaft != '') {
			$scope.ergebnis[zeile].mannschaft.used = zeile;
		}
		var selectedIds = [];
		for (var i = 0; i < $scope.mannschaften.length; i++) {
			if($scope.ergebnis[i].mannschaft != null && $scope.ergebnis[i].mannschaft != '') {
				selectedIds.push($scope.ergebnis[i].mannschaft.id);
			}
		}
		for (var i = 0; i < $scope.mannschaften.length; i++) {
			if(selectedIds.indexOf($scope.mannschaften[i].id) < 0) {
				if($scope.mannschaften[i].used >= 0) {
					$scope.mannschaften[i].used = -1;
				}
			}
		}
	}

	$scope.submit = function ($event) {
		if($scope.form.$valid) {
			$event.currentTarget.disabled = true;
			$event.currentTarget.innerText = 'Daten werden übertragen…';
			$http({
				method: 'POST',
				url: $scope.routes.melden,
				data: {
					liga: $scope.liga,
					turnier: $scope.turnier,
					ergebnis: $scope.ergebnis,
					wertungsrichter: $scope.wertungsrichter,
					absender: $scope.absender
				}
			}).then(
				function (response) {
					swal({
						title: 'Ergebnis übermittelt',
						text: 'Das gemeldete Ergebnis wurde erfolgreich übermittelt und wird nun geprüft.',
						timer: 5000,
						type: 'success',
						showConfirmButton: true
					});
					$scope.turnier = null;
					$scope.liga = null;
					$scope.form.$setPristine();
					$scope.form.$setUntouched();
					$event.currentTarget.disabled = false;
					$event.currentTarget.innerText = 'absenden';
				},
				function (response) {
					swal({
						title: 'Übermittlungsfehler',
						text: 'Die Daten konnten nicht übermittelt werden. Bitte versuchen Sie es erneut.',
						type: 'error',
						showConfirmButton: true
					});
					$event.currentTarget.disabled = false;
					$event.currentTarget.innerText = 'absenden';
				}
			);
		}
	}

	$scope.$watch('anzahlWr', function (newValue, oldValue, scope) {
		if (newValue && newValue != '' && newValue != oldValue) {
			if (scope.turnier != null) {
				initData();
			}
		}
	});

	$scope.$watch('liga', function (newValue, oldValue, scope) {
		if (newValue && newValue != oldValue) {
			if (newValue.isTurnier) {
				scope.turnier = null;
				scope.turniere = [];
				scope.mannschaften = [];
				$http({
					method: 'GET',
					url: $scope.routes.stammdatenTurnier + '?t=' + $scope.liga.id
				}).then(function (response) {
					scope.turnier = newValue;
					scope.turniere = [newValue];
					scope.mannschaften = response.data.mannschaften;
					scope.mannschaften.forEach(function (m) {
						m.used = -1;
					});
					scope.landesverbaende = response.data.landesverbaende;
				});
			} else {
				scope.turnier = null;
				scope.turniere = [];
				scope.mannschaften = [];
				$http({
					method: 'GET',
					url: $scope.routes.stammdatenLiga + '?l=' + $scope.liga.id
				}).then(function (response) {
					scope.turniere = response.data.turniere;
					scope.mannschaften = response.data.mannschaften;
					scope.mannschaften.forEach(function (m) {
						m.used = -1;
					});
					scope.landesverbaende = response.data.landesverbaende;
				});
			}
		}
	});

	$scope.$watch('turnier', function (newValue, oldValue, scope) {
		if (newValue && newValue != oldValue) {
			initData();
		}
	});
}]);
