<?php

namespace Tanzsport;

use Contao\BackendTemplate;
use Contao\Widget;

class FreiesturnierErgebnisWidget extends Widget
{
    /**
     * Submit user input
     * @var boolean
     */
    protected $blnSubmitInput = true;

    /**
     * Template
     * @var string
     */
    protected $strTemplate = 'be_widget';

    /**
     * @var FreiesturnierMannschaftModel[]
     */
    private $arrMannschaften = array();

    /**
     * @var Ergebnisarchiv
     */
    private $ergebnisarchiv;

    public function __construct($arrAttributes = null)
    {
        parent::__construct($arrAttributes);

        $this->ergebnisarchiv = new Ergebnisarchiv();
    }

    public function generate()
    {
        $template = new BackendTemplate('widget_freiesturnierergebnis');

        $this->arrMannschaften[] = array(0, '(keine Auswahl)');
        $objResult = $this->ladeMannschaften();
        if ($objResult) {
            while ($objResult->next()) {
                $this->arrMannschaften[] = array($objResult->id, sprintf('%1$s %2$s (%3$s)', $objResult->verein_name, $objResult->team_name, $objResult->startnr));
            }
        }

        $template->strId = $this->strId;
        $template->platzziffern = $this->generatePlatzziffern(count($this->arrMannschaften) - 1);
        $template->mannschaften = $this->arrMannschaften;
        $template->anzahlWr = $this->activeRecord->wertungsrichter_anzahl;
        $template->rundenUndStati = $this->ergebnisarchiv->getRundenUndStatiMitLabel();
        $template->landesverbaende = $this->ergebnisarchiv->getLandesverbaende();
        if ($this->varValue) {
            $template->value = $this->varValue;
        } else {
            $template->value = $this->createDefaultValues(count($this->arrMannschaften) - 1, $this->activeRecord->anzahlWr);
        }
        $template->activeRecord = $this->activeRecord;
        return $template->parse();
    }

    private function ladeMannschaften()
    {
        return FreiesturnierMannschaftModel::findByTurnier($this->activeRecord->id);
    }

    private function generatePlatzziffern($intAnzahl)
    {
        for ($i = 1; $i <= $intAnzahl; $i++) {
            $arrPlatzziffern[] = $i;
            if ($i != $intAnzahl) {
                $arrPlatzziffern[] = $i + 0.5;
            }
        }
        $arrPlatzziffern[] = $intAnzahl + 1;
        $arrPlatzziffern[] = $intAnzahl + 2;
        return $arrPlatzziffern;
    }

    private function createDefaultValues($intAnzahlMannschaften, $intAnzahlWr)
    {
        $arrDefault = array();
        for ($i = 0; $i < $intAnzahlMannschaften; $i++) {
            $arrDefault[] = $this->createDefaultValue($i, $intAnzahlWr);
        }
        return $arrDefault;
    }

    private function createDefaultValue($i, $intAnzahlWr)
    {
        return array(
            'pz' => $i + 1,
            'mannschaft' => 0,
            'runde' => '',
            'wertung' => array_fill(0, $intAnzahlWr - 1, '')
        );
    }

    public static function saveCallback($value, \DC_Table $dc)
    {
        return $value;
    }

    protected function validator($varInput)
    {
        return parent::validator($varInput);
    }

}
