<?php

namespace Tanzsport;

class ModuleErgebnisarchivBundesliga extends ModuleErgebnisarchiv
{

    protected $strTemplate = 'mod_ergebnisarchiv_bundesliga';

    private $objPage;

    public function generate()
    {
        if (TL_MODE == 'BE') {
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### ' . utf8_strtoupper($GLOBALS['TL_LANG']['FMD']['td_ergebnisarchiv_bundesliga'][0]) . ' ###';
            $objTemplate->title = $this->headline;
            $objTemplate->id = $this->id;
            $objTemplate->link = $this->name;
            $objTemplate->href = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        if ($this->jumpTo) {
            $this->objPage = \PageModel::findByPk($this->jumpTo);
        }

        return parent::generate();
    }

    protected function compile()
    {
        $this->loadLanguageFile('tl_td_erg');

        $arrTurnierarten = deserialize($this->td_erg_turnierarten, true);
        if (count($arrTurnierarten) > 0) {
            $objSaison = SaisonModel::findLatestPublished();
            if ($objSaison) {
                $this->Template->saisonTitel = $objSaison->getSaisonTitel($arrTurnierarten[0]);

                $strBereich = in_array(Ergebnisarchiv::TURNIERART_JMD, $arrTurnierarten) ? Ergebnisarchiv::BEREICH_J_BL : Ergebnisarchiv::BEREICH_F_BL;

                // ligen
                $arrLigen = [];
                $objLigen = LigaModel::findPublishedBySaisonAndLigabereich($objSaison, $strBereich);
                if ($objLigen != null) {
                    while ($objLigen->next()) {
                        $objLiga = $objLigen->current();
                        $strLiga = $GLOBALS['TL_LANG'][\Tanzsport\Ergebnisarchiv::LNG_KEY][$objLiga->liga];
                        if (!isset($arrLigen[$strLiga])) {
                            $arrLigen[$strLiga] = [];
                        }
                        $arrLigen[$strLiga][] = $this->renderDisplayLiga($objSaison, $objLiga);
                    }
                }
                $this->Template->ligen = $arrLigen;

                // turniere
                $arrTurniere = [];
                $objTurniere = FreiesturnierModel::findPublishedBySaisonAndLigabereich($objSaison, $strBereich);
                if ($objTurniere != null) {
                    while ($objTurniere->next()) {
                        $objTurnier = $objTurniere->current();
                        $arrTurniere[] = $this->renderDisplayTurnier($objTurnier);
                    }
                }
                $this->Template->turniere = $arrTurniere;
            }
        }
    }

    private function renderDisplayLiga(SaisonModel $objSaison, LigaModel $objLiga)
    {
        if ($this->objPage != null) {
            return $this->renderLinkLiga($objSaison->jahr, $objLiga, $this->objPage);
        } else {
            return $objLiga->titel;
        }
    }

    private function renderDisplayTurnier(FreiesturnierModel $objTurnier)
    {
        if ($this->objPage != null) {
            return $this->renderLinkTurnier($objTurnier, $this->objPage);
        } else {
            return $objTurnier->titel;
        }
    }
}
