<?php

namespace Tanzsport;

/**
 * Class SaisonInfoModel
 * @package Tanzsport
 *
 * @property int $pid Saison-ID
 * @property string $bereich Ligabereich
 * @property string $info Inhalt
 * @property bool $published veröffentlicht
 */
class SaisonInfoModel extends \Model
{

    protected static $strTable = "tl_td_erg_info";

    public function __get($key)
    {
        switch ($key) {
            default:
                return parent::__get($key);
        }
    }

    public function __isset($key)
    {
        switch ($key) {
            default:
                return parent::__isset($key);
        }
    }

    /**
     * @return SaisonInfoModel
     */
    public static function findOneBySaisonAndLigabereich(SaisonModel $objSaison, $bereich)
    {
        $t = self::$strTable;
        return self::findOneBy(["$t.pid = ?", "$t.bereich = ?"], [$objSaison->id, $bereich]);
    }

}
