<?php

$GLOBALS['TL_DCA']['tl_td_erg_liga_turnier'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'ptable' => 'tl_td_erg_liga',
        'ctable' => array(),
        'enableVersioning' => true,
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'pid' => 'index',
            )
        ),
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 4,
            'flag' => 12,
            'fields' => array('datum'),
            'headerFields' => array('bereich', 'liga', 'turnierart', 'nr', 'bezeichnung', 'pid'),
            'header_callback' => array('tl_td_erg_liga_turnier', 'zeigeLiga'),
            'panelLayout' => 'sort,filter;search,limit',
            'child_record_callback' => array('tl_td_erg_liga_turnier', 'listeTurniere'),
            'child_record_class' => 'no_padding',
            'disableGrouping' => true,
        ),
        'label' => array
        (
            'fields' => array('bereich'),
            'format' => '%1$s'
        ),
        'global_operations' => array
        (/*
			'all' => array
			(
				'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
				'href' => 'act=select',
				'class' => 'header_edit_all',
				'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"'
			)
			*/
        ),
        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.gif'
            ),
            /*
            'copy' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['copy'],
                'href' => 'act=copy',
                'icon' => 'copy.gif'
            ),
            */
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.gif',
                'attributes' => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"',
                'button_callback' => array('tl_td_erg_liga_turnier', 'deleteIcon')
            ),
            /*
            'toggle' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['toggle'],
                'icon' => 'visible.gif',
                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
//				'button_callback' => array('tl_td_erg_liga', 'toggleIcon')
            ),
            */
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga']['show'],
                'href' => 'act=show',
                'icon' => 'show.gif'
            )
        )
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array('wertungsrichter_erfassen', 'ergebnis_erfassen'),
        'default' => '{turnier_legend},datum,ort,wertungsrichter_anzahl;{turnierstaette_legend:hide},tst_halle,tst_telefon,tst_adresse;{zeitplan_legend:hide},zeiten_einlass,zeiten_beginn;{eintrittskarten_legend:hide},zeiten,karten;{vvk_legend:hide},vvk_text,vvk_anschrift,vvk_telefon,vvk_fax,vvk_email_adresse,vvk_email_text,vvk_online_url,vvk_online_text,vvk_bemerkungen;{anfahrt_legend:hide},anfahrt_text,anfahrt_url;{ergebnis_legend},ergebnis_erfassen;{wr_legend:hide},wertungsrichter_erfassen;{veroeffentlichung_legend},turnier_published,ergebnis_published,ergebnis_annulliert'
    ),

    // Subpalettes
    'subpalettes' => array
    (
        'wertungsrichter_erfassen' => 'wertungsrichter',
        'ergebnis_erfassen' => 'ergebnis_vorbehalt,ergebnis',
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'pid' => array
        (
            'foreignKey' => 'tl_td_erg_liga.id',
            'sql' => "int(10) unsigned NOT NULL default '0'",
            'relation' => array('type' => 'belongsTo', 'load' => 'eager')
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'datum' => array
        (
            'sql' => "varchar(12) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['datum'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => false,
            'sorting' => false,
            'default' => date('d.m.Y', time()),
            'eval' => array('mandatory' => true, 'rgxp' => 'date', 'datepicker' => true, 'tl_class' => 'w50 wizard'),
            'unique' => true,
        ),
        'ort' => array
        (
            'sql' => "varchar(96) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['ort'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => true, 'maxlength' => 96, 'tl_class' => 'w50'),
        ),
        'tst_halle' => array
        (
            'sql' => "varchar(96) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['tst_halle'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 96, 'tl_class' => 'w50'),
        ),
        'tst_telefon' => array
        (
            'sql' => "varchar(96) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['tst_telefon'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 96, 'tl_class' => 'w50'),
        ),
        'tst_adresse' => array
        (
            'sql' => "blob NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['tst_adresse'],
            'exclude' => false,
            'inputType' => 'textarea',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'rte' => 'tinyMCE', 'tl_class' => 'clr'),
        ),
        'zeiten_einlass' => array
        (
            'sql' => "varchar(96) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['zeiten_einlass'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 96, 'tl_class' => 'w100'),
        ),
        'zeiten_beginn' => array
        (
            'sql' => "blob NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['zeiten_beginn'],
            'exclude' => false,
            'inputType' => 'tdTurnierzeitenWidget',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'rows' => 6, 'tl_class' => 'w100 wizard'),
            'save_callback' => array(array('\Tanzsport\TurnierzeitenWidget', 'saveCallback')),
        ),
        'karten' => array
        (
            'sql' => "blob NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['karten'],
            'exclude' => false,
            'inputType' => 'tdKartenWidget',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'rows' => 6, 'tl_class' => 'clr'),
            'save_callback' => array(array('\Tanzsport\KartenWidget', 'saveCallback')),
        ),
        'vvk_text' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['vvk_text'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'vvk_anschrift' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['vvk_anschrift'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'vvk_telefon' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['vvk_telefon'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'vvk_fax' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['vvk_fax'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'vvk_email_text' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['vvk_email_text'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'vvk_email_adresse' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['vvk_email_adresse'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50', 'rgxp' => 'email'),
        ),
        'vvk_online_text' => array
        (
            'sql' => "varchar(128) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['vvk_online_text'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 128, 'tl_class' => 'w50'),
        ),
        'vvk_online_url' => array
        (
            'sql' => "varchar(256) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['vvk_online_url'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 96, 'tl_class' => 'w50', 'rgxp' => 'url'),
        ),
        'vvk_bemerkungen' => array
        (
            'sql' => "blob NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['vvk_bemerkungen'],
            'exclude' => false,
            'inputType' => 'textarea',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'rte' => 'tinyMCE', 'tl_class' => 'clr'),
        ),
        'anfahrt_text' => array
        (
            'sql' => "blob NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['anfahrt_text'],
            'exclude' => false,
            'inputType' => 'textarea',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'rte' => 'tinyMCE', 'tl_class' => 'clr'),
        ),
        'anfahrt_url' => array
        (
            'sql' => "varchar(256) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['anfahrt_url'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => false, 'maxlength' => 96, 'tl_class' => 'w50', 'rgxp' => 'url'),
        ),
        'ergebnis_erfassen' => array
        (
            'sql' => "char(1) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['ergebnis_erfassen'],
            'exclude' => false,
            'default' => '',
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50', 'submitOnChange' => true),
        ),
        'ergebnis_vorbehalt' => array
        (
            'sql' => "char(1) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['ergebnis_vorbehalt'],
            'exclude' => false,
            'default' => '',
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
        ),
        'ergebnis_annulliert' => array
        (
            'sql' => "char(1) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['ergebnis_annulliert'],
            'exclude' => false,
            'default' => '',
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
        ),
        'ergebnis' => array
        (
            'sql' => 'blob NULL',
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['ergebnis'],
            'exclude' => false,
            'inputType' => 'tdLigaturnierErgebnisWidget',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'tl_class' => 'w100 clr wizard', 'doNotCopy' => true),
            'save_callback' => array(array('\Tanzsport\LigaturnierErgebnisWidget', 'saveCallback')),
        ),
        'wertungsrichter_anzahl' => array
        (
            'sql' => "tinyint(1) NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['wertungsrichter_anzahl'],
            'exclude' => false,
            'inputType' => 'select',
            'options' => array('3', '5', '7', '9', '11', '13'),
            'search' => false,
            'sorting' => false,
            'default' => 5,
            'eval' => array('mandatory' => true, 'rgxp' => 'digit', 'tl_class' => 'w50', 'submitOnChange' => true),
            'unique' => true,
        ),
        'wertungsrichter_erfassen' => array
        (
            'sql' => "char(1) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['wertungsrichter_erfassen'],
            'exclude' => false,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50', 'submitOnChange' => true),
        ),
        'wertungsrichter' => array
        (
            'sql' => 'blob NULL',
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['wertungsrichter'],
            'exclude' => false,
            'inputType' => 'tdWertungsrichterWidget',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'tl_class' => 'clr wizard', 'doNotCopy' => true),
            'save_callback' => array(array('\Tanzsport\WertungsrichterWidget', 'saveCallback')),
        ),
        'turnier_published' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['turnier_published'],
            'exclude' => false,
            'filter' => true,
            'flag' => 1,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
            'sql' => "char(1) NOT NULL default ''"
        ),
        'ergebnis_published' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_liga_turnier']['ergebnis_published'],
            'exclude' => false,
            'filter' => true,
            'flag' => 1,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
            'sql' => "char(1) NOT NULL default ''"
        ),
    )
);

class tl_td_erg_liga_turnier extends Backend
{

    public function __construct()
    {
        parent::__construct();
        $this->import('BackendUser', 'User');
    }

    public static function listeTurniere($arrRow)
    {
        $html = '<div class="tl_content_left">' . date('d.m.Y', $arrRow['datum']) . ' (' . $arrRow['ort'] . ')</div>';
        return $html;
    }

    public static function zeigeLiga($arrFields)
    {
        $ret = array();
        foreach ($arrFields as $k => $v) {
            if ($k == 'pid') {
                $ret['Saison'] = $v;
            } else {
                $ret[$k] = $v;
            }
        }
        return $ret;
    }

    public function deleteIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (!$this->User->isAdmin) {
            return;
        }
        return '<a href="' . $this->addToUrl('&amp;act=delete&amp;id=' . $row['id']) . '" title="' . specialchars($title) . '"' . $attributes . '>' . Image::getHtml($icon, $label) . '</a> ';
    }

}
