<?php

$GLOBALS['TL_DCA']['tl_td_erg_info'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'ptable' => 'tl_td_erg_saison',
        'enableVersioning' => true,
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'pid' => 'index',
                'pid,bereich' => 'unique',
            )
        ),
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 4,
            'flag' => 12,
            'fields' => array('bereich'),
            'headerFields' => array('jahr'),
//			'fields' => array('bereich'),
            'panelLayout' => 'sort,filter;search,limit',
            'child_record_callback' => array('tl_td_erg_info', 'listeInfo'),
            'child_record_class' => 'no_padding',
            'disableGrouping' => true,
            'filter' => \Tanzsport\Ergebnisarchiv::getLigabereicheByUser(),
        ),
        'label' => array
        (
            'fields' => array('bereich'),
            'format' => '%1$s'
        ),
        'global_operations' => array
        (
            'all' => array
            (
                'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
                'href' => 'act=select',
                'class' => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_info']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.gif'
            ),
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_info']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.gif',
                'attributes' => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"'
            ),
            'toggle' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_info']['toggle'],
                'icon' => 'visible.gif',
                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
                'button_callback' => array('tl_td_erg_info', 'toggleIcon')
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_td_erg_info']['show'],
                'href' => 'act=show',
                'icon' => 'show.gif'
            )
        )
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array(''),
        'default' => '{saisoninfo_legend},bereich,info;{veroeffentlichung_legend},published'
    ),

    // Subpalettes
    'subpalettes' => array
    (
        '' => ''
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'pid' => array
        (
            'foreignKey' => 'tl_td_erg_saison.jahr',
            'sql' => "int(10) unsigned NOT NULL default '0'",
            'relation' => array('type' => 'belongsTo', 'load' => 'eager')
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'bereich' => array
        (
            'sql' => "varchar(12) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_info']['bereich'],
            'exclude' => false,
            'inputType' => 'select',
            'options_callback' => array('\Tanzsport\Ergebnisarchiv', 'getVerfuegbareLigabereicheMitLabelInternal'),
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => true, 'includeBlankOption' => true, 'tl_class' => 'w50'),
            'unique' => true,
            'reference' => &$GLOBALS['TL_LANG'][\Tanzsport\Ergebnisarchiv::LNG_KEY]['internal']
        ),
        'info' => array
        (
            'sql' => "blob NULL",
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_info']['info'],
            'exclude' => false,
            'inputType' => 'textarea',
            'search' => false,
            'sorting' => false,
            'eval' => array('mandatory' => false, 'rte' => 'tinyMCE', 'tl_class' => 'clr'),
        ),
        'published' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_td_erg_info']['published'],
            'exclude' => false,
            'filter' => true,
            'flag' => 1,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true),
            'sql' => "char(1) NOT NULL default ''"
        ),
    )
);

\System::loadLanguageFile('tl_td_erg');

class tl_td_erg_info extends Backend
{
    public function __construct()
    {
        parent::__construct();
        $this->import('BackendUser', 'User');
    }

    public static function listeInfo($arrRow)
    {
        return '<div class="tl_content_left">' . $GLOBALS['TL_LANG'][\Tanzsport\Ergebnisarchiv::LNG_KEY]['internal'][$arrRow['bereich']] . '</div>';
    }

    public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (strlen(Input::get('tid'))) {
            $this->toggleVisibility(Input::get('tid'), (Input::get('state') == 1));
            $this->redirect($this->getReferer());
        }

        $href .= '&amp;tid=' . $row['id'] . '&amp;state=' . ($row['published'] ? '' : 1);

        if (!$row['published']) {
            $icon = 'invisible.gif';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '"' . $attributes . '>' . Image::getHtml($icon, $label) . '</a> ';
    }

    public function toggleVisibility($intId, $blnVisible)
    {
        $objVersions = new Versions('tl_td_erg_info', $intId);
        $objVersions->initialize();

        if (is_array($GLOBALS['TL_DCA']['tl_td_erg_info']['fields']['published']['save_callback'])) {
            foreach ($GLOBALS['TL_DCA']['tl_td_erg_info']['fields']['published']['save_callback'] as $callback) {
                if (is_array($callback)) {
                    $this->import($callback[0]);
                    $blnVisible = $this->$callback[0]->$callback[1]($blnVisible, $this);
                } elseif (is_callable($callback)) {
                    $blnVisible = $callback($blnVisible, $this);
                }
            }
        }

        // Update the database
        $this->Database->prepare("UPDATE tl_td_erg_info SET tstamp=" . time() . ", published='" . ($blnVisible ? 1 : '') . "' WHERE id=?")
            ->execute($intId);

        $objVersions->create();
    }

}
