<?php
declare(strict_types=1);

namespace Tanzsport\ContaoFormationenBundle\Controller\Api;

use Tanzsport\Ergebnisarchiv;
use Tanzsport\FreiesturnierMannschaftModel;
use Tanzsport\LigaMannschaftModel;
use Tanzsport\LigaTurnierModel;

trait StammdatenErgebnisTrait
{

    public function loadStammdatenLiga(string $liga): array
    {
        $data = [
            'turniere' => [],
            'mannschaften' => [],
            'landesverbaende' => [],
        ];

        $turniere = LigaTurnierModel::findPublishedByLigaOrderByDatum($liga);
        if ($turniere) {
            foreach ($turniere as $turnier) {
                $data['turniere'][] = $turnier->asArray();
            }
            $mannschaften = LigaMannschaftModel::findPublishedByLigaOrderByStartnr($liga);
            if ($mannschaften) {
                foreach ($mannschaften as $mannschaft) {
                    $data['mannschaften'][] = $mannschaft->asArray();
                }
            }
            foreach ((new Ergebnisarchiv())->getLandesverbaendeMitLabel() as $key => $label) {
                $data['landesverbaende'][] = ['key' => $key, 'label' => $label];
            }
        }

        return $data;
    }

    public function loadStammdatenTurnier(string $turnier): array
    {
        $data = [
            'turniere' => [],
            'mannschaften' => [],
            'landesverbaende' => [],
        ];
        $mannschaften = FreiesturnierMannschaftModel::findPublishedByTurnierOrderByStartnr($turnier);
        if ($mannschaften) {
            foreach ($mannschaften as $mannschaft) {
                $data['mannschaften'][] = $mannschaft->asArray();
            }
            foreach ((new Ergebnisarchiv())->getLandesverbaendeMitLabel() as $key => $label) {
                $data['landesverbaende'][] = ['key' => $key, 'label' => $label];
            }
        }

        return $data;
    }
}
